# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit jeppson-hofmann.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, 
                      warning = FALSE, 
                      message = FALSE,
                      # fig.pos = "!h",
                      cache = TRUE,
                      out.width='100%', 
                      layout="l-page",
                      fig.align = "center"
                      )
# install_github("haleyjeppson/ggmosaic")
library(ggmosaic)
library(patchwork)
library(tidyverse)
library(forcats)
library(plotly)


## ----modify-data, cache = FALSE-----------------------------------------------
# A few modifications to data for the paper
flights <- fly %>% 
  select(do_you_recline, rude_to_recline, eliminate_reclining) %>% 
  filter(!is.na(do_you_recline), !is.na(rude_to_recline)) %>% 
  mutate(do_you_recline = fct_collapse(do_you_recline,
                                  usually = c("always", "usually"),
                                  sometimes = c("about half the time", "once in a while"),
                                  never = c("never")),
         do_you_recline = forcats::fct_relevel(do_you_recline, "never", "sometimes"))


## ----theme, cache = FALSE-----------------------------------------------------
# create theme
theme_mosaic <- function (base_size = 12, base_family = "Helvetica") {
  theme_gray() +
    theme(
      rect = element_rect(fill = NA, linetype = 0, colour = NA, size = base_size/22),
      text = element_text(family = base_family, face = "plain", color = "black",
                          size = base_size, hjust = 0.5, vjust = 0.5, angle = 0,
                          lineheight = 0.9, margin = margin(), debug = FALSE),
      axis.title = element_text(size = rel(.7)),
      axis.text = element_text(size = rel(.6)),
      legend.text = element_text(size = rel(.6)),
      legend.title = element_text(size = rel(.7)),
      panel.grid.major.y = element_blank(),
      panel.grid.minor.y = element_blank(),
      panel.grid.major.x = element_blank(),
      panel.grid.minor.x = element_blank(),
      panel.border = element_blank(),
      panel.background = element_blank(),
      legend.position = "right",
      legend.key = element_rect(fill = "#FFFFFF00"),
      plot.title = element_text(size = rel(.75)),
      plot.subtitle = element_text(size = rel(.65)),
      legend.key.size = unit(.9, "lines"),
      aspect.ratio = 1
    )
}

# set theme
theme_set(theme_mosaic())

# color pallette
okabe <- c("#E69F00", "#56B4E9", "#009E73", "#F0E442","#0072B2", "#D55E00", "#CC79A7")
mypal <- okabe


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # productplots
#> productplots::prodplot(flights, ~do_you_recline + rude_to_recline, mosaic()) +
#>   aes(fill = do_you_recline)
#> 
#> ## ggmosaic
#> ggplot(data = flights) +
#>    geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                    fill = do_you_recline))


## ----prodplot, fig.height=3, fig.cap="Example mosaic plots made with the productplots package (left) and the ggmosaic package (right). While the differences are subtle in this basic example, the differences between the two packages become more apparent as the customization of the mosaic plot increases."----
library(productplots)
pp <- productplots::prodplot(flights, ~ do_you_recline + rude_to_recline, mosaic()) + aes(fill=do_you_recline) +  
  scale_fill_manual(values = mypal, name="Do you recline?") + 
  theme(legend.position = "none") 

detach("package:productplots", unload=TRUE)
library(ggmosaic)

gg <- ggplot(data = flights) +
   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline), fill=do_you_recline), offset = .012) + 
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none")

pp + gg


## ----echo=TRUE, eval = FALSE--------------------------------------------------
#> # one-dimensional examples:
#> # spine plot
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline))
#> 
#> # bar chart
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline),
#>               divider = "hbar")


## ----variety1, fig.height = 2.4, fig.pos = "!h", fig.cap = 'Both plots represent the distribution of \\code{do\\_you\\_recline} and allow the same comparisons, though the spine plot does so with proportions and the bar chart with frequencies. The relative group sizes are more difficult to compare in the spine plot, but the \\code{"sometimes"} group is still discernable as the largest and the \\code{"never"} group as the smallest. The bar chart provides an easier comparisons of the relative group sizes.'----
bar_examp <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline), 
              divider="hbar", color = "white") + 
  scale_fill_manual("Do you recline?", values = mypal, guide = guide_legend(reverse = TRUE)) + 
  theme(axis.text.y = element_blank(),
        axis.ticks.y = element_blank()) +
  coord_fixed() +
  labs(x="", y = "", title = "Bar Chart")

spine_examp <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline), 
              color = "white") +
  scale_fill_manual("Do you recline?", values = mypal, guide = guide_legend(reverse = TRUE)) + 
  theme(axis.text.y = element_blank(),
        axis.ticks.y = element_blank()) +
  coord_fixed() +
  labs(x="", y = "", title = "Spine Plot")

spine_examp + bar_examp + plot_layout(guides = 'collect')


## ----echo=TRUE, eval = FALSE--------------------------------------------------
#> # two-dimensional examples:
#> # mosaic plot (2 variables)
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline))
#> 
#> # stacked bar chart
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline),
#>               divider = c("vspine", "hbar"))


## ----variety2, fig.pos = "!h", fig.cap = 'The conditional distribution of \\code{do\\_you\\_recline} given \\code{rude\\_to\\_recline} is represented by the heights of the bars in both the mosaic plot (left) and the stacked bar chart (right). The mosaic plot displays the joint and marginal distribution of \\code{rude\\_to\\_recline} with the area and width of the tile, respectively. The stacked bar chart reveals a nearly equal number of never reclining responses across the categories of \\code{rude\\_to\\_recline}. The conditional probabilities of \\code{"never"} given \\code{"somewhat"} and \\code{"never"} given \\code{"yes"} have a more significant impact in the mosaic plot, from which we understand that there is a positive correlation between a respondent considering reclining to be rude and electing never to recline their seat. There are, however, respondents that do not consider reclining to be rude and yet never recline, and perhaps more egregious, there are those that do regard reclining as rude and yet usually recline their seats, a group that is important in the mosaic plot but challenging to see in the stacked bar chart.'----
stackbar_examp <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline, rude_to_recline), fill = do_you_recline),
              divider=c("vspine", "hbar"), color = "white") +   
  scale_fill_manual("Do you recline?", values = mypal, guide = guide_legend(reverse = TRUE)) +  
  coord_fixed() +
  labs(x="Is it rude to recline?", y = "", title = "Stacked Bar Chart")

mosaic_examp <- ggplot(data = flights) +
  geom_mosaic(aes(x = product(do_you_recline, rude_to_recline), fill = do_you_recline), 
              color = "white") +   
  scale_fill_manual("Do you recline?", values = mypal, guide = guide_legend(reverse = TRUE)) +  
  coord_fixed() +
  labs(y="", x="Is it rude to recline?", title = "Mosaic Plot (2 variables)") 

mosaic_examp + stackbar_examp + plot_layout(guides = 'collect')


## ----echo=TRUE, eval = FALSE--------------------------------------------------
#> # three-dimensional examples:
#> # mosaic plot (3 variables)
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(eliminate_reclining, do_you_recline,
#>                               rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining))
#> 
#> # double-decker plot
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, eliminate_reclining,
#>                               rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining),
#>               divider = ddecker())
#> 


## ----variety3, fig.pos = "!h", fig.cap = 'The mosaic plot (left) and double-decker plot (right) include the three variables (\\code{do\\_you\\_recline}, \\code{rude\\_to\\_recline}, \\code{eliminate\\_reclining}), though the direction of the splits varies between the two plots. Both plots display a connection between a passenger\'s opinions of reclining and their tendency to recline. Those that consider reclining to be rude are less likely to recline and more likely to wish for reclining to be eliminated. The mosaic plot reveals an increasing desire to eliminate reclining when the respondents believe reclining to be rude across all categories of \\code{do\\_you\\_recline}. There appears to be a slight positive correlation between reclining and not electing to eliminate reclining across all levels of \\code{rude\\_to\\_recline}. The double-decker plot (a mosaic plot with a specific structure) best highlights the conditional distribution of \\code{do\\_you\\_recline} and allows for easier comparisons across the categories of the other two variables. For example, the relationship between \\code{do\\_you\\_recline} and \\code{eliminate\\_reclining} seems consistent across categories of \\code{rude\\_to\\_recline}, a conclusion that is less readily available from the mosaic plot.'----
mosaic2_examp <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(eliminate_reclining, do_you_recline, rude_to_recline), fill = do_you_recline, alpha = eliminate_reclining),
              offset = 0.015, color = "white") + 
  scale_fill_manual("Do you recline?", values = mypal) + 
  scale_alpha_manual("Eliminate reclining?", values = c(.6,1)) +
  theme(legend.position = "none",
        axis.text.x = element_text(angle = 90, hjust = 1, vjust = .5)) + 
  labs(y="Do you recline?", x="Eliminate reclining?:Is it rude to recline?", title = "Mosaic Plot (3 variables)") +
  coord_fixed()

ddecker_examp <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline, eliminate_reclining, rude_to_recline), fill = do_you_recline, alpha = eliminate_reclining),
              divider = ddecker(), offset = 0.015, color = "white") + 
  scale_fill_manual("Do you recline?", values = mypal) + 
  scale_alpha_manual("Eliminate reclining?", values = c(.6, 1)) +
  theme(axis.text.x = element_text(angle = 90, hjust = 1, vjust = .5)) + 
  labs(y="Do you recline?", x="Eliminate reclining?: Is it rude to recline?", title = "Double-Decker Plot") +
  coord_fixed() +
  guides(fill = guide_legend(order = 1, reverse = TRUE), alpha = guide_legend(order = 2, reverse = TRUE))

mosaic2_examp + ddecker_examp


## ----echo = TRUE--------------------------------------------------------------
# A few modifications to data
flights <- fly %>% 
  select(do_you_recline, rude_to_recline, eliminate_reclining) %>% 
  filter(!is.na(do_you_recline), !is.na(rude_to_recline)) %>% 
  mutate(do_you_recline = do_you_recline %>% 
           forcats::fct_collapse(
             usually = c("always", "usually"),
             sometimes = c("about half the time", "once in a while"),
             never = "never") %>% 
           forcats::fct_relevel("never", "sometimes", "usually")
         )

# Summary of the modified data
flights %>% summary()


## ----echo = TRUE--------------------------------------------------------------
flights_examp <- flights %>% select(do_you_recline, rude_to_recline)
names(flights_examp)


## ----type1, echo = TRUE-------------------------------------------------------
glimpse(flights_examp)


## ----type2, echo = TRUE-------------------------------------------------------
flights_examp %>% 
  count(do_you_recline, rude_to_recline, name = "freq") %>% 
  glimpse()


## ----type3, echo = TRUE-------------------------------------------------------
flights_examp %>% table()


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # unweighted plot
#> flights_examp %>%
#>   count(do_you_recline, rude_to_recline, name = "freq") %>%
#>   ggplot() +
#>   geom_mosaic(aes(x = product(rude_to_recline),
#>                   fill = do_you_recline))
#> 
#> # weighted plot
#> flights_examp %>%
#>   count(do_you_recline, rude_to_recline, name = "freq") %>%
#>   ggplot() +
#>   geom_mosaic(aes(weight = freq,
#>                   x = product(rude_to_recline),
#>                   fill = do_you_recline))


## ----weight, fig.height=3, fig.cap = "When using summarized data, a weighting aesthetic must be defined for the resulting mosaic plot to remain a faithful representation of the data. The mosaic plot on the left contains nine equally sized tiles for the nine combinations that result from the three levels of \\code{rude\\_to\\_recline} crossed with the three levels of \\code{do\\_you\\_recline}. The mosaic plot on the right considers the frequency of those nine combinations resulting in nine tiles proportional to the number of observations each tile represents."----
weight1 <- flights_examp %>%
  count(do_you_recline, rude_to_recline, name = "freq") %>% 
  ggplot() +
  geom_mosaic(aes(x=product(rude_to_recline), fill = do_you_recline), 
              color = "white") +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Unweighted") 

weight2 <- flights_examp %>%
  count(do_you_recline, rude_to_recline, name = "freq") %>% 
  ggplot() +
  geom_mosaic(aes(weight = freq, x=product(rude_to_recline), fill = do_you_recline), 
              color = "white") +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none")+  
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Weighted") 
  
weight1 + weight2


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # original order
#> ggplot(data = flights) +
#> geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                 fill = do_you_recline))
#> 
#> # order reversed
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline, do_you_recline),
#>                   fill = do_you_recline))


## ----order, fig.height=3, fig.cap = "While the mosaics represent the same data, each supports different comparisons. The mosaic plot on the left emphasizes the effect \\code{rude\\_to\\_recline} has on \\code{do\\_you\\_recline}. The variable order was reversed in the construction of the mosaic plot on the right resulting in a plot that emphasizes the effect \\code{do\\_you\\_recline} has on \\code{rude\\_to\\_recline}."----
order1 <- mosaic_examp +  
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Original Order") + 
  theme(legend.position = "none")

order2 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(rude_to_recline, do_you_recline), fill = do_you_recline), 
              color = "white") +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(x="Do you recline?", y="Is it rude to recline?", title = "Order Reversed") 
  
order1 + order2


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # not conditioned
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline),
#>                   fill = do_you_recline))
#> 
#> # conditioned with aesthetic mapping
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline,
#>                   conds = product(rude_to_recline)))
#> 
#> # conditioned with facets
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline)) +
#>   facet_grid(cols = vars(rude_to_recline))


## ----conds, fig.height=6, fig.cap = "Mosaic plots typically depict the joint distribution (top left mosaic plot) but can instead depict the conditional distribution using facetting (bottom left mosaic plot) or the \`conds` aesthetic (top right mosaic plot). Conditioning on \\code{rude\\_to\\_recline} may provide a clearer view of the relationship the responses to \\code{do\\_you\\_recline} has with \\code{rude\\_to\\_recline}. However, we lose information on the marginal distribution of \\code{rude\\_to\\_recline}, and the area of a tile is only comparable to the other tiles within that same level of \\code{rude\\_to\\_recline}."----
cond1 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline, rude_to_recline), fill = do_you_recline),
              color = "white") +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none") +
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Not Conditioned") 
  
cond2 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline, conds = product(rude_to_recline)), 
              color = "white") +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Conditioned via Aesthetic Mapping") 

facet1 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline), 
              color = "white", divider = "vspine") +
  facet_grid(cols = vars(rude_to_recline)) +
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none", 
        aspect.ratio = 3, 
        axis.ticks.x = element_blank(), 
        axis.text.x = element_blank()) + 
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Conditioned via Facets") 

cond1 + cond2 + facet1 + plot_spacer() + plot_layout(nrow = 2, heights = c(1,1))


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # not conditioned
#> ggplot(flights) +
#>   geom_mosaic(aes(x = product(eliminate_reclining, do_you_recline,
#>                               rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining))
#> 
#> # conditioned
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(eliminate_reclining),
#>                   conds = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining))


## ----conds3, fig.height=3.4, fig.cap = 'An example of using conditioning to focus on one relationship. The left mosaic plot represents the joint distribution of reclining tendencies, the perceived rudeness of reclining, and the desire to eliminate reclining, providing an overall picture. In the mosaic plot on the right, conditioning on \\code{rude\\_to\\_recline} and \\code{do\\_you\\_recline} removes the representation of the joint distribution of reclining tendencies and the perceived rudeness of reclining but provides a clearer view of the conditional distribution of \\code{eliminate\\_reclining}.'----
notcond <- ggplot(flights) +
  geom_mosaic(aes(x=product(eliminate_reclining, do_you_recline, rude_to_recline), fill = do_you_recline, alpha = eliminate_reclining),
              offset = 0.015, color = "white") + 
  scale_fill_manual(values = mypal) + 
  scale_alpha_manual(values = c(.7,.9)) +
  theme(legend.position = "none",
        axis.text.x = element_text(angle = 90, hjust = 1, vjust = .5)) + 
  labs(x="Eliminate reclining?:Rude to recline?", y = "Do you recline?") +
  coord_fixed()
  
condord2 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(eliminate_reclining), conds = product(rude_to_recline, do_you_recline), fill = do_you_recline, alpha = eliminate_reclining),
              color = "white", offset = 0.02) + 
  scale_fill_manual(values = mypal) + 
  scale_alpha_manual(values =c(.7,.9)) +
  theme(legend.position = "none",
        axis.text.x = element_text(angle = 90, hjust = 1, vjust = .5)) + 
  scale_y_productlist(breaks = c(0.1566682, 0.4963580, 0.8360477), labels = c("never", "sometimes", "usually")) +
  labs(x="Eliminate reclining:Do you recline?", y="Is it rude to recline?") +
  coord_flip()

condord1 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(eliminate_reclining), conds = product(do_you_recline, rude_to_recline), fill = do_you_recline, alpha = eliminate_reclining), 
              color = "white", offset = 0.02) + 
  scale_fill_manual(values = mypal) + 
  scale_alpha_manual(values =c(.7,.9)) +
  theme(legend.position = "none",
        axis.text.x = element_text(angle = 90, hjust = 1, vjust = .5)) + 
  scale_y_productlist(breaks = c(0.1566682, 0.4963580, 0.8360477), labels = c("never", "sometimes", "usually")) +
  labs(y="Do you recline?", x="Eliminate reclining:Is it rude to recline?")

notcond + condord1


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # conditioned order 1
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(eliminate_reclining),
#>                   conds = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining))
#> 
#> # conditioned order 2
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(eliminate_reclining),
#>                   conds = product(rude_to_recline, do_you_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining)) +
#>   coord_flip()


## ----conds-orders, fig.height=3.4, fig.cap = "The two mosaic plots both portray the distribution of \\code{eliminate\\_reclining} conditioned on \\code{do\\_you\\_recline} and \\code{rude\\_to\\_recline}, but the direction of the final split is different. The lefthand plot is better suited to compare \\code{eliminate\\_reclining} with \\code{do\\_you\\_recline}, while the righthand plot is better suited to compare \\code{eliminate\\_reclining} with \\code{rude\\_to\\_recline}. The comparison of interest should influence the order of the conditioning variables."----
condord1 + condord2


## ----echo=TRUE, eval = FALSE--------------------------------------------------
#> # default / hspine
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline))
#> 
#> # vspine
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline),
#>               divider = "vspine")
#> 
#> # hbar
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline),
#>               divider = "hbar")
#> 
#> # vbar
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   fill = do_you_recline),
#>               divider = "vbar")


## ----part1, fig.pos = "h", fig.height=2, fig.cap = "Examples of the four ways each dimension in a mosaic plot can be partitioned. While the values are easier to compare with the bars in this one-dimensional example, the advantages of spines become more apparent in higher-dimensional examples."----
part1 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline),
              color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = "hspine")

part2 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline),
              divider = "vspine", color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = "vspine")

part3 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline),
              divider = "hbar", color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = "hbar")

part4 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline),
              divider = "vbar", color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = "vbar")

part1 + part2 + part3 + part4 + plot_layout(nrow = 1)


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # default / mosaic("h")
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(eliminate_reclining, do_you_recline,
#>                               rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining))
#> 
#> # mosaic("v")
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(eliminate_reclining, do_you_recline,
#>                               rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining),
#>               divider = mosaic(direction = "v"))
#> 
#> # ddecker
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, eliminate_reclining,
#>                               rude_to_recline),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining),
#>               divider = ddecker())
#> 
#> # c("hbar", "hbar", "vspine")
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline,
#>                               eliminate_reclining),
#>                   fill = do_you_recline,
#>                   alpha = eliminate_reclining),
#>               divider = c("hbar", "hbar", "vspine"))


## ----part3, fig.height = 2, fig.cap = 'When multiple variables are included, a partition type must be defined for each variable, and the different partitions emphasize different relationships. The \\code{mosaic()} and \\code{ddecker()} functions automatically define a partition for each variable, and are shown in the first and third mosaic plots, respectively. \\code{mosaic("v")}, shown in the second plot, is similar to \\code{mosaic("h")}, but the coordinates are flipped and inversed. Alternatively, a type of partition can be defined manually for each dimension. \\code{ddecker()} emphasizes the conditional distribution of the final variable. In the final plot, the divider \\code{c("hbar", "hbar", "vspine")} creates a plot similar to a faceted bar chart that supports comparisons similar to those supported by the double-decker plot but for relative values instead of relative proportions.'----
part1 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline, rude_to_recline), fill = do_you_recline, alpha = eliminate_reclining),
              color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  scale_alpha_manual(values =c(.7,.9)) +
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = 'mosaic() (default)')

part2 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline, rude_to_recline), fill = do_you_recline, alpha = eliminate_reclining),
              divider = mosaic(direction = "v"), color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  scale_alpha_manual(values =c(.7,.9)) +
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = 'mosaic("v")')

part3 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(rude_to_recline, eliminate_reclining), fill = do_you_recline, alpha = eliminate_reclining),
              divider = c("hbar", "hbar", "vspine"), color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  scale_alpha_manual(values =c(.7,.9)) +
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = 'c("hbar", "hbar", "vspine")')

part4 <- ggplot(data = flights) + 
  geom_mosaic(aes(x=product(do_you_recline, eliminate_reclining, rude_to_recline), fill = do_you_recline, alpha = eliminate_reclining),
              divider = ddecker(), color = "white", show.legend = FALSE) +  
  scale_fill_manual(values = mypal) + 
  scale_alpha_manual(values =c(.7,.9)) +
  theme(axis.text = element_blank(),
        axis.ticks = element_blank()) +
  labs(x="", y = "", title = 'ddecker()')

part1 + part2 + part4 + part3 + plot_layout(nrow = 1)


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # increased spacing
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline),
#>                   fill = do_you_recline),
#>               offset = 0.03)
#> 
#> # decreased spacing
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline),
#>                   fill = do_you_recline),
#>               offset = 0)
#> 
#> # default spacing
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline),
#>                   fill = do_you_recline))


## ----space, fig.height=6, fig.cap = "Three examples of how the spacing of the splits in the mosaic plot can be increased or decreased with the offset parameter."----
space1 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline, rude_to_recline), fill = do_you_recline)) +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Default spacing")
  
space2 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline, rude_to_recline), fill = do_you_recline), offset = 0.0) +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Decreased spacing")

space3 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline, rude_to_recline), fill = do_you_recline), offset = 0.03) +   
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Increased spacing")


space3 + space2 + space1 + plot_spacer() + plot_layout(nrow = 2, heights = c(1,1))


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> p1 <- ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline),
#>                   fill = do_you_recline))
#> 
#> plotly::ggplotly(p1)


## ----plotly-static, eval=knitr::is_latex_output(), fig.cap="Users can create interactive mosaic plots using  \\pkg{ggmosaic} with \\pkg{plotly}. With plotly, users gain the ability to hover over a tile to see the names of the combination of levels and the number of observations that the tile represents.", out.width = "60%"----
knitr::include_graphics("plotly.png")


## ----plotly-interactive, eval=knitr::is_html_output(), fig.cap="Users can create interactive mosaic plots using  \\pkg{ggmosaic} with \\pkg{plotly}. With plotly, users gain the ability to hover over a tile to see the names of the combination of levels and the number of observations that the tile represents."----
#> p1 <- ggplot(data = flights) +
#>    geom_mosaic(aes(x = product(do_you_recline, rude_to_recline), fill=do_you_recline), offset = .012) +
#>   scale_fill_manual(values = mypal, name="Do you recline?") +
#>   theme(legend.position = "none") +
#>   labs(x="Is it rude to recline?", y="Do you recline?")
#> 
#> plotly::ggplotly(p1, height = 400, width = 400)


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline)) +
#>   geom_mosaic_text(aes(x = product(do_you_recline, rude_to_recline)))


## ----labels, fig.pos = "h", fig.height=3, fig.cap = "In this example, a geom of labels is layered on top of the mosaic geom to produce a mosaic plot with labels centered in each tile. Directly labeling each tile can alleviate issues caused by inadequate space around the perimeter for labels."----
ggplot(data = flights) +
  geom_mosaic(aes(x = product(do_you_recline, rude_to_recline), fill = do_you_recline), 
              offset = .012, show.legend = FALSE) +
  geom_mosaic_text(aes(x=product(do_you_recline, rude_to_recline)), 
                   size = 3, offset = .012) +
  scale_fill_manual(values = mypal) + 
  theme(axis.text = element_blank(), axis.ticks = element_blank()) +  
  labs(x = "Is it rude to recline?", y = "Do you recline?")


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline)) +
#>   geom_mosaic_text(aes(x = product(do_you_recline, rude_to_recline),
#>                        label = after_stat(.wt)))


## ----labels2, fig.height=3, fig.cap = "Variables calculated by the associated stat can be used for the label. In this example, \\code{.wt} is used to place the frequencies represented by the tile in the center of that tile, providing a glance at the size of the data and removing potential guessing work aimed at comparing areas of unaligned tiles."----
ggplot(data = flights) +
  geom_mosaic(aes(x = product(do_you_recline, rude_to_recline), fill = do_you_recline), 
              offset = .012, show.legend = FALSE) +
  geom_mosaic_text(aes(x=product(do_you_recline, rude_to_recline), label = after_stat(.wt)),
              size = 3, offset = .012) +
  scale_fill_manual(values = mypal) + 
  theme(axis.text = element_blank(), axis.ticks = element_blank()) +  
  labs(x = "Is it rude to recline?", y = "Do you recline?", title = "`label = after_stat(.wt)`")


## ----eval = FALSE, echo = TRUE------------------------------------------------
#> # default / text
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline)) +
#>   geom_mosaic_text(aes(x = product(do_you_recline, rude_to_recline)))
#> 
#> # label
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline)) +
#>   geom_mosaic_text(aes(x = product(do_you_recline, rude_to_recline)),
#>                    as.label = TRUE)
#> 
#> # repel text
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline)) +
#>   geom_mosaic_text(aes(x = product(do_you_recline, rude_to_recline)),
#>                    repel = TRUE)
#> 
#> # repel label
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline, rude_to_recline),
#>                   fill = do_you_recline)) +
#>   geom_mosaic_text(aes(x = product(do_you_recline, rude_to_recline)),
#>                    repel = TRUE, as.label = TRUE)


## ----label-opts, fig.height=7, fig.cap = 'Examples of the four geoms accessible to \\code{geom\\_mosaic\\_text()}. The geoms, from left to right and top to bottom, are \\code{"Text"}, \\code{"Label"}, \\code{"TextRepel"}, and \\code{"LabelRepel"}.'----
base <- ggplot(data = flights) +
  geom_mosaic(aes(x = product(rude_to_recline), fill = do_you_recline), 
              offset = .012, show.legend = FALSE) +
  scale_fill_manual(values = mypal) + 
  theme(axis.text = element_blank(), axis.ticks = element_blank()) +  
  labs(x = "Is it rude to recline?", y = "Do you recline?")

opt1 <- base +
  geom_mosaic_text(aes(x=product(do_you_recline, rude_to_recline)), 
                   size = 3, offset = .012) +
  ggtitle("")

opt2 <- base +
  geom_mosaic_text(aes(x=product(do_you_recline, rude_to_recline)), 
                   size = 3, offset = .012, as.label = TRUE) +
  ggtitle("`as.label = TRUE`")

opt3 <- base +
  geom_mosaic_text(aes(x=product(do_you_recline, rude_to_recline)), 
                   size = 3, offset = .012, repel = TRUE) +
  ggtitle("repel = TRUE")

opt4 <- base +
  geom_mosaic_text(aes(x=product(do_you_recline, rude_to_recline)),
                   size = 3, offset = .012, repel = TRUE, as.label = TRUE) +
  ggtitle("repel = TRUE, as.label = TRUE")

opt1 + opt2 + opt3 + opt4 + plot_layout(ncol = 2)


## ----echo = TRUE, eval = FALSE------------------------------------------------
#> # not conditioned
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline),
#>                   fill = do_you_recline),
#>               alpha = 0.3) +
#>   geom_mosaic_jitter(aes(x = product(rude_to_recline),
#>                          color = do_you_recline))
#> 
#> # conditioned
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(do_you_recline),
#>                   conds = product(rude_to_recline),
#>                   fill = do_you_recline),
#>               alpha = 0.3)  +
#>   geom_mosaic_jitter(aes(x = product(do_you_recline),
#>                          conds = product(rude_to_recline),
#>                          color = do_you_recline))


## ----jitter, fig.height=3.5, fig.pos = "h", fig.cap = "This example highlights the differences between the conditional (right) and joint (left) probability with the density of the jittered dots. When conditioning, the columns are equally sized, and the jittered points condense into the leftmost column, previously the widest column, rather than being evenly dispersed."----
jitter1 <- ggplot(data = flights) +
  geom_mosaic(aes(x = product(rude_to_recline), fill = do_you_recline), 
              alpha = 0.3, offset = .025) +
  geom_mosaic_jitter(aes(x=product(rude_to_recline), color = do_you_recline), 
                     offset = .025, size = 1)  +   
  scale_fill_manual(values = mypal) + 
  scale_color_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(title = "Not conditioned", x = "Is it rude to recline?", y = "Do you recline?")
  

jitter2 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline), conds=product(rude_to_recline), fill = do_you_recline), 
              alpha = 0.3, offset = .025)  +
  geom_mosaic_jitter(aes(x=product(do_you_recline), conds=product(rude_to_recline), color = do_you_recline),
                     offset = .025, size = 1) +   
  scale_fill_manual(values = mypal) + 
  scale_color_manual(values = mypal) + 
  theme(legend.position = "none") +  
  labs(title = "Conditioned", x = "Is it rude to recline?", y = "Do you recline?")
  
jitter1 + jitter2


## ----eval=FALSE, echo=TRUE----------------------------------------------------
#> # drop level
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline)),
#>               alpha = 0.1) +
#>   geom_mosaic_jitter(aes(x = product(rude_to_recline),
#>                          color = do_you_recline),
#>                      drop_level = TRUE)
#> # do not drop level
#> ggplot(data = flights) +
#>   geom_mosaic(aes(x = product(rude_to_recline)),
#>               alpha = 0.1) +
#>   geom_mosaic_jitter(aes(x = product(rude_to_recline),
#>                          color = do_you_recline),
#>                      drop_level = FALSE)


## ----leveldown, fig.height=3.5, fig.cap = "The parameter \\code{drop\\_level} controls which level defines the colors of the generated points. On the left, color is added to the points one level down, and a mixing of the colored points occurs. In the plot on the right, the heights of the sorted points' spaces represent the conditional distribution of \\code{do\\_you\\_recline} given \\code{rude\\_to\\_recline}. "----
base <- ggplot(data = flights) +
  geom_mosaic(aes(x = product(rude_to_recline)), 
              alpha = 0.1, offset = .025) +
  scale_color_manual("Do you recline?", values = mypal, guide = guide_legend(reverse = TRUE)) + 
  theme(axis.ticks.y = element_blank(),
        axis.text.y = element_blank()) +  
  labs(x = "Is it rude to recline?", y = " ")

jitter1 <- base +
  geom_mosaic_jitter(aes(x=product(rude_to_recline), color = do_you_recline), 
                     drop_level = TRUE, offset = .025, size = 1) + 
  theme(legend.position = "none")+
  ggtitle("`drop_level = TRUE`")

jitter2 <- base  +
  geom_mosaic_jitter(aes(x=product(rude_to_recline), color = do_you_recline),
                     drop_level = FALSE, offset = .025, size = 1) +
  ggtitle("`drop_level = FLASE`")
  
jitter1 + jitter2


## -----------------------------------------------------------------------------
# independence example
flights_counts <- flights %>% 
  count(do_you_recline, rude_to_recline) 

ind_mod <- glm(n~do_you_recline + rude_to_recline, data = flights_counts, family = "poisson")

flights_counts$dat = "Observed Data"

flights_model <- flights_counts %>% 
  dplyr::select(-dat) %>% 
  mutate(Expected = round(predict(ind_mod, type = "response"))) %>% 
  rename("Observed" = n) 


## ----echo = TRUE--------------------------------------------------------------
flights_model %>% glimpse()


## ----echo = TRUE, eval = FALSE------------------------------------------------
#> flights_model %>%
#>   gather("wt_type", "wt", Expected:Observed) %>%
#>   ggplot() +
#>   geom_mosaic(aes(weight = wt,
#>                   x = product(rude_to_recline),
#>                   fill = do_you_recline)) +
#>   facet_wrap(vars(wt_type))


## ----model, fig.height = 3.5, fig.pos = "h", fig.cap = "While mosaic plots are typically drawn according to the observed values, they can be drawn according to the model's expected values. The mosaic plot on the right displays the expected values from the independence model, recognizable by the lattice structure. The differences in the heights of the tiles in the observed data mosaic plot on the left reveal a strong association between the two variables, and the differences between the two plots highlight the lack of model fit."----
flights_counts %>% 
  dplyr::select(-dat) %>% 
  mutate(Expected = predict(ind_mod, type = "response")) %>% 
  rename("Observed" = n) %>% 
  gather("wt_type", "wt", Expected:Observed) %>% 
  mutate(wt_type = factor(wt_type, levels = c("Observed", "Expected"))) %>% 
  ggplot() + 
  geom_mosaic(aes(weight = wt, x = product(do_you_recline, rude_to_recline), fill = do_you_recline), 
              offset = .02, show.legend = FALSE) +
  facet_wrap(vars(wt_type)) +
  scale_fill_manual(values = mypal) +
  labs(x = "Is it rude to recline?", y = "Do you recline?") 


## ----eval=FALSE, echo=TRUE----------------------------------------------------
#> ggplot(flights_model) +
#>   geom_mosaic(aes(weight = Expected,
#>                   x = product(do_you_recline, rude_to_recline)),
#>               alpha = .2) +
#>   geom_mosaic_jitter(aes(weight2 = Observed,
#>                          weight = Expected,
#>                          x = product(do_you_recline, rude_to_recline)))


## ----weight2, fig.height=3, fig.cap = "In this example, the tiles of the mosaic plot are drawn according to the expected values. A jitter geom representing the observed values is layered on top. The uneven dispersal of the points indicates a lack of fit."----
ggplot(flights_model) + 
  geom_mosaic(aes(weight = Expected, x = product(do_you_recline, rude_to_recline)), 
              alpha = .2, offset = .03) +
  geom_mosaic_jitter(aes(weight2 = Observed, weight = Expected, x = product(do_you_recline, rude_to_recline)), 
                     alpha = .8, offset = .03, size = 1) +  
  labs(x = "Is it rude to recline?", y = "Do you recline?")


## ----themes, fig.height=3.2, fig.cap = "This example highlights the differences between the custom theme (left) and the default theme (right). The custom theme for mosaic plots seeks to minimize clutter by removing the plot background and the grid lines."----
yestheme <- ggplot(data = flights) +
  geom_mosaic(aes(x = product(rude_to_recline), fill = do_you_recline), offset = .015) +
  scale_fill_manual(values = mypal, na.value = "azure4", name="Do You Recline") + 
  theme_mosaic() +
  theme(legend.position = "none") +  
  labs(x = "Is it rude to recline?", y = "Do you recline?", title = "`plot + theme_mosaic()`")

# set theme back to default
theme_set(theme_gray())

notheme <- ggplot(data = flights) +
  geom_mosaic(aes(x = product(rude_to_recline), fill = do_you_recline), offset = .015) +
  scale_fill_manual(values = mypal, na.value = "azure4", name="Do You Recline") +  
  labs(x = "Is it rude to recline?", y = "Do you recline?", title = "default ggplot2 theme") +
  theme(axis.title = element_text(size = rel(.6)), 
      axis.text = element_text(size = rel(.5)),
      legend.text = element_text(size = rel(.5)),
      legend.title = element_text(size = rel(.6)),
      legend.position = "none", 
      plot.title = element_text(size = rel(.65)),
      plot.subtitle = element_text(size = rel(.55)),
      legend.key.size = unit(.9, "lines"))

yestheme + notheme


## -----------------------------------------------------------------------------
# reset theme
theme_set(theme_mosaic())


## ----aspect, fig.height=3.2, fig.cap = "When using faceting, the aspect ratio might need to be adjusted according to the desired outcome. The default (left) represents each facet as a 1-by-1 mosaic plot, whereas an aspect ratio of 3 (right) represents each facet as one equal-sized column within a 1-by-1 mosaic plot."----
aspect1 <- ggplot(data = flights) +
  geom_mosaic(aes(x=product(do_you_recline), fill = do_you_recline), 
              color = "white", divider = "vspine") +
  facet_grid(cols = vars(rude_to_recline)) +
  scale_fill_manual(values = mypal) + 
  theme(legend.position = "none", 
        axis.ticks.x = element_blank(), 
        axis.text.x = element_blank()) + 
  labs(y="Do you recline?", x="Is it rude to recline?", title = "Aspect Ratio = 1 (theme default)")

aspect3 <- aspect1 +
  theme(aspect.ratio = 3) +
  labs(title = "Aspect Ratio = 3")

aspect1 + aspect3 + plot_layout(widths = c(1, 1))


## ----app, out.width = "100%", fig.cap = 'A snapshot of the Shiny application that can be launched with the function \\code{ggmosaic\\_app()}. The Shiny app facilitates learning how to create mosaic plots. The user can explore one of three data sets provided with the package with mosaic plots created and modified via keystrokes or buttons, and no coding is required.'----
knitr::include_graphics("app.png")

