# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit smith.Rmd to modify this file

## ----init, echo = FALSE-------------------------------------------------------
set.seed(0)


## ----flowchart, out.width = "60%", fig.cap = "Flow charts summarizing key functions available in TreeSearch.", fig.align="center", echo = FALSE----
ifelse(knitr::is_html_output(), "Flow.svg", "Flow.pdf") |>
  knitr::include_graphics()


## ----simple-search, message = FALSE-------------------------------------------
library("TreeSearch")
vinther <- inapplicable.phyData[["Vinther2008"]]
trees <- MaximizeParsimony(vinther, concavity = 10, tolerance = 0.05)


## ----results------------------------------------------------------------------
TreeLength(trees, dataset = vinther, concavity = 10) |> 
  signif() |>         # truncate non-significant digits
  table()             # tabulate by score
attr(trees, "firstHit")


## ----map-results, fig.asp = 1, fig.cap="Mapping of trees found in simple search, coloured according to parsimony score under implied weights, with concavity constant of 10"----
distances <- TreeDist::ClusteringInfoDistance(trees)
map <- cmdscale(distances, k = 2) # A serious analysis would consider > 2 dims
scores <- vapply(trees, TreeLength, 1, vinther, concavity = 10)
scoreBins <- cut(scores, nBins <- 4)
cols <- hcl.colors(nBins, alpha = 0.8)
par(mai = rep(0, 4))
plot(map, col = cols[scoreBins], pch = 16, cex = 2,
     axes = FALSE, xlab = '', ylab = '', asp = 1)
TreeTools::MSTEdges(distances, plot = TRUE, map[, 1], map[, 2],
                    col = '#00000030', lty = 2)
legend("topright", attr(scoreBins, "levels"), col = cols, pch = 16,
       title = "Tree score", bty = "n")


## ----treespace-html, eval=knitr::is_html_output(), out.width = "100%", fig.cap = "Three-dimensional map visualizing progress in a tree search in the TreeSearch GUI. Optimal trees belong to three statistically distinct clusters with good support (silhouette coefficient $>$ 0.5), characterized by different relationships between certain taxa (plotting symbols). Although multiple ratchet iterations have visited each cluster, limited overlap between ratchet iterations suggests that a continuation of tree search may sample novel optimal trees. High trustworthiness and continuity values and a simple minimum spanning tree (grey) indicate that the mapping does not exhibit severe distortion. This figure depicts the tree space GUI display after loading the @Wills2012 dataset; clearing previous trees from memory (sample _n_ trees = 0); and starting a new search (Search&rarr;Configure) with equal step weighting and 10<sup>1.5</sup> max hits. 93 trees were sampled, coloured by \"When first found\", with plotting symbols depicting \"Relationships\" between the specified taxa.", fig.alt="TreeSpace GUI showing map of tree space with visualization of tree search progress", echo = FALSE----
#> knitr::include_graphics("TreeSpace.svg")

## ----treespace-latex, eval=knitr::is_latex_output(), out.width = "100%", fig.cap = "(ref:treespace-caption)", fig.alt="TreeSpace GUI showing map of tree space with visualization of tree search progress", echo = FALSE----
knitr::include_graphics("TreeSpace.pdf")


## ----rogueplot-latex, eval=knitr::is_latex_output(), out.width = "100%", fig.cap = "(ref:rogueplot-caption)", fig.alt="TreeSearch GUI display showing plot of reduced consensus, coloured by leaf stability", echo = FALSE----
knitr::include_graphics("WillsCons.pdf")


## ----rogueplot-html, eval=knitr::is_html_output(), out.width = "100%", fig.cap = "Reduced consensus of 48 cladograms generated by analysis of data from @Wills2012 under different parsimony methods by @Brazeau2019, as displayed in the TreeSearch graphical user interface. Removal of taxa reveals strong support for relationships that would otherwise be masked by rogues such as _Palaeoscolex_, whose position in optimal trees is marked by the highlighted edges. The GUI state can be reproduced by selecting the options displayed in the figure.", fig.alt="TreeSearch GUI display showing plot of reduced consensus, coloured by leaf stability", echo = FALSE----
#> knitr::include_graphics("WillsCons.svg")

