# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit mlr3fairness.Rmd to modify this file

## ----setup, include = FALSE---------------------------------------------------
options(tinytex.verbose = TRUE)
set.seed(4444L)
library("mlr3misc")
library("ggplot2")
library("mlr3tuning")
library("patchwork")

options(digits = 4, scipen = 1)
lgr::get_logger("bbotk")$set_threshold("error")
lgr::get_logger("mlr3")$set_threshold("error")

cite = function(x) {
  paste0('\\citeauthor{', x, '}, ', '\\hyperlink{ref-', x, '}',
                          '{\\citeyear{', x, '}}')
}


## -----------------------------------------------------------------------------
library("mlr3verse")
library("mlr3fairness")

task = tsk("adult_train")
print(task)


## -----------------------------------------------------------------------------
learner = lrn("classif.rpart", predict_type = "prob")
idx = partition(task)
learner$train(task, idx$train)
prediction = learner$predict(task, idx$test)


## -----------------------------------------------------------------------------
measure = msr("classif.acc")
prediction$score(measure)


## -----------------------------------------------------------------------------
resampling = rsmp("cv", folds = 10)
rr = resample(task, learner, resampling)


## -----------------------------------------------------------------------------
rr$aggregate(measure)


## ---- warning = FALSE---------------------------------------------------------
learner2 = lrn("classif.log_reg", predict_type = "prob")

grid = benchmark_grid(task, list(learner, learner2), resampling)
bmr = benchmark(grid)

bmr$aggregate(measure)[, .(learner_id, classif.acc)]


## ---- warning = FALSE, include = FALSE----------------------------------------
library(mlr3viz)
autoplot(bmr, measure = measure)


## ----bmrbox, echo = FALSE, warning = FALSE, fig.height = 3.5, fig.width = 3.5, fig.cap = "Model comparison based on accuracy for decision trees (rpart) and logistic regression (log\\_reg) across resampling splits.", fig.align = 'center', fig.alt = "Side-by-side comparison of twoboxplots for the rpart and log\\_reg learners, both showing a classification accuracy of around .845 and IQR of .005 with log\\_reg having slightly higher accuracy."----
library(mlr3viz)
autoplot(bmr, measure = measure) +
  theme(
    strip.background = element_blank(),
    strip.text.x = element_blank(),
    panel.border = element_blank(),
    axis.line = element_blank()
  ) +
  theme(axis.text.x = element_text(angle = 30, hjust = .7))


## ---- eval = FALSE------------------------------------------------------------
#> task$set_col_roles("marital_status", add_to = "pta")


## -----------------------------------------------------------------------------
measures = list(msr("classif.acc"), msr("fairness.eod"))
rr$aggregate(measures)


## ---- echo = FALSE, results = 'hide'------------------------------------------
eodi = round(rr$aggregate(measures)[2], 2)


## -----------------------------------------------------------------------------
fairness_tensor(rr)


## ---- eval = FALSE------------------------------------------------------------
#> fairness_prediction_density(prediction, task)
#> compare_metrics(prediction, msrs(c("fairness.fpr", "fairness.tpr", "fairness.eod")), task)


## ----predplots, echo = FALSE, fig.height=3, fig.width=6, fig.align='center', fig.cap = "Visualizing predictions of the decision tree model. Left: Prediction densities for the negative class for Female and Male. Right: Fairness metrics comparison for FPR, TPR, EOd metrics. Plots show a higher likelihood for the '<50k' class for females resulting in fairness metrics different from 0.", fig.alt = "Two pannel plot. On the left hand side, a plot of rediction densities for the negative class for groups Female and Male with density concentrating towards the right.  Plots show a higher likelihood for the '<50k' class for females resulting in large fairness metrics. Right: Fairness metrics comparison using bar plots for FPR, TPR, EOd metrics indicating disparities of aroung 0.1 for all metrics."----
library(patchwork)
p1 = fairness_prediction_density(prediction, task) + theme(legend.position="bottom")
p2 = compare_metrics(prediction, msrs(c("fairness.fpr", "fairness.tpr", "fairness.eod")), task)
(p1 + xlab("") + p2) * theme_bw() + theme(axis.text.x = element_text(angle = 25, hjust = .7))


## ---- eval = FALSE------------------------------------------------------------
#> po("reweighing_wts") %>>% lrn("classif.glmnet")
#> po("learner_cv", lrn("classif.glmnet")) %>>% po("EOd")


## -----------------------------------------------------------------------------
library("mlr3verse")
library("mlr3fairness")

task = tsk("adult_train")
print(task)

measures = msrs(c("fairness.tpr", "classif.acc"))


## ---- message = FALSE, warning = FALSE, error = FALSE-------------------------
set.seed(4321)
learners = list(
    lrn("classif.rpart"),
    po("encode") %>>% lrn("classif.glmnet"),
    po("encode") %>>% po("reweighing_wts") %>>% lrn("classif.glmnet")
)

grid = benchmark_grid(
  tasks = tsks("adult_train"),
  learners = learners,
  resamplings = rsmp("cv", folds = 3)
)

bmr1 = benchmark(grid)
bmr1$aggregate(measures)[, c(4, 7, 8)]


## -----------------------------------------------------------------------------
metric = msr("fairness.constraint",
    performance_measure = msr("classif.acc"),
    fairness_measure = msr("fairness.eod"),
    epsilon = 0.01
)


## ---- echo = FALSE, message = FALSE-------------------------------------------
# Enable parallelization utilizing all cores
# future::plan("multisession")

lrn = as_learner(po("encode") %>>% po("reweighing_wts") %>>% po("learner", lrn("classif.glmnet")))

# Define the parameter space to optimize over
vals = list(
  reweighing_wts.alpha = to_tune(0.8, 1),
  classif.glmnet.alpha = to_tune(0.8, 1),
  classif.glmnet.s = to_tune(1e-4, 1e-2, logscale = TRUE)
)
# Add search space to the learner
lrn$param_set$values = insert_named(lrn$param_set$values, vals)


## -----------------------------------------------------------------------------
tuning_iters = 3
at = AutoTuner$new(lrn, rsmp("holdout"),
    metric,
    tuner = mlr3tuning::tnr("random_search"),
    terminator = trm("evals", n_evals = tuning_iters)
)
at$id = "glmnet_weighted_tuned"

grd = benchmark_grid(
  tasks = tsks("adult_train"),
  learners = list(at),
  resamplings = rsmp("cv", folds = 3)
)

bmr2 = benchmark(grd, store_models = TRUE)
bmr2$aggregate(measures)[, c(4, 7, 8)]


## ---- results = 'hide', include = FALSE, fig.width = 6, fig.height = 4, fig.align='center', fig.cap = "Fairness-Accuracy tradeoff for 3-fold CV on the adult train set."----
bmr = c(bmr1, bmr2)
fairness_accuracy_tradeoff(bmr, fairness_measure = measures[[1]])


## ----fat, echo = FALSE, fig.width = 6, fig.height = 4, fig.align='center', fig.cap = "Fairness-Accuracy tradeoff for 3-fold CV on the adult train set.", dpi=300----
bmr = c(bmr1, bmr2)
fairness_accuracy_tradeoff(bmr, fairness_measure = measures[[1]]) +
  guides(shape = "none") +
  theme_minimal()


## -----------------------------------------------------------------------------
bmr$aggregate(measures)[, c(4, 7, 8)]


## -----------------------------------------------------------------------------
at_lrn = bmr$learners$learner[[4]]
at_lrn$train(tsk("adult_train"))


## ---- warning = FALSE---------------------------------------------------------
test = tsk("adult_test")
at_lrn$predict(test)$score(measures, test)


## ---- eval = TRUE, echo=FALSE-------------------------------------------------
eval_appendix = TRUE

