# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit toum.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
library(hydrotoolbox)
library(kableExtra)


## ----class-htb, echo = F, out.width="70%", fig.align="center", fig.cap= "Classes for hydrometeorological data in $\\textbf{hydrotoolbox}$ package. Arrows indicate the class that each entity inherits from. The dotted arrow means that an $\\texttt{hydromet\\_station}$ class can be transformed (by the $\\texttt{hm\\_melt}$ method) to a  $\\texttt{hydromet\\_compact}$ class object."----

knitr::include_graphics(path = "./flow_diagram_classes_crop.png")



## ----table-variables-html, eval = knitr::is_html_output(), echo=F, message=FALSE----
#> library(hydrotoolbox)
#> library(kableExtra)
#> 
#> Slot     <- c(slotNames("hydromet_station")[1:8], ".", ".", ".")
#> Variable <- c("water-height vs stream-discharge measurements",
#>               "water height level records",
#>               "hourly mean river discharge",
#>               "daily mean river discharge",
#>               "monthly mean river discharge",
#>               "annual river discharge",
#>               "wind speed",
#>               "wind direction",
#>               ".", ".", ".")
#> 
#> df_var <- data.frame(Slot, Variable)
#> 
#> df_var %>%
#>   kbl(caption = "Eight out of forty hydrometeorological variables supported in $\\texttt{hydromet_station}$ class (use $\\texttt{slotNames(x = \"hydromet_station\")}$ to see all of them). In the package most of them are rectangular tables containing date series in their first column ($\\texttt{Date}$ and $\\texttt{POSIX*}$ classes are allowed).",
#>       booktabs = T, escape = F,
#>       format = "html")%>%
#>   row_spec(0, bold = TRUE) #%>%
#>   # kable_styling(font_size = 7)


## ----table-variables-static, eval = knitr::is_latex_output(), echo=F, message=FALSE----
library(hydrotoolbox)
library(kableExtra)

Slot     <- c(slotNames("hydromet_station")[1:8], ".", ".", ".")
Variable <- c("water-height vs stream-discharge measurements",
              "water height level records",
              "hourly mean river discharge", 
              "daily mean river discharge",
              "monthly mean river discharge", 
              "annual river discharge",
              "wind speed", 
              "wind direction", 
              ".", ".", ".")

df_var <- data.frame(Slot, Variable)

df_var %>%
  kbl(caption = "Eight out of forty hydrometeorological variables supported in \\texttt{hydromet\\_station} class (use \\texttt{slotNames(x = \"hydromet\\_station\")} to see all of them). In the package most of them are rectangular tables containing date series in their first column (\\texttt{Date} and \\texttt{POSIX*} classes are allowed).",
      booktabs = T, escape = F,
      format = "latex")%>% 
  row_spec(0, bold = TRUE) %>%
  kable_styling(font_size = 9)


## ----table-methods-html, eval = knitr::is_html_output(), echo=F, message=FALSE----
#> Metodo   <- c("$\\texttt{hm_agg}$",
#>               "$\\texttt{hm_build_generic}$",
#>               "$\\texttt{hm_create}$",
#>               "$\\texttt{hm_get}$",
#>               "$\\texttt{hm_melt}$",
#>               "$\\texttt{hm_mutate}$",
#>               "$\\texttt{hm_name}$",
#>               "$\\texttt{hm_plot}$",
#>               "$\\texttt{hm_report}$",
#>               "$\\texttt{hm_set}$",
#>               "$\\texttt{hm_show}$",
#>               "$\\texttt{hm_subset}$")
#> 
#> Descrip  <- c("temporally aggregates  data",
#>               "automatically loads raw data inside the $\\texttt{hydromet_station}$ object",
#>               "constructs the $\\texttt{hydromet}$ class and its subclasses",
#>               "extracts the required table (or metadata) from the object",
#>               "merges several tables into a single one and set it into a $\\texttt{hydromet_compact}$ class object",
#>               "creates, modifies and deletes columns inside an object table (slot)",
#>               "changes data frame column names",
#>               "makes static and dynamic graphs of the required hydrometeorological variables",
#>               "gets basic statistic and a table with missing data",
#>               "assigns the (meta)data to an $\\texttt{hydromet}$ class or subclass object",
#>               "shows the head or tail of the tables inside the object",
#>               "subsets the required table")
#> 
#> df_method <- data.frame(Metodo, Descrip)
#> 
#> colnames(df_method) <- c("Method", "Description")
#> 
#> df_method %>%
#>   kbl(caption = "Processing operations for object manipulation in the \\pkg{hydrotoolbox} package.",
#>       booktabs = T,
#>       escape = F,
#>       format = "html") %>%
#>   row_spec(0, bold = TRUE) %>%
#>   column_spec(column = 1) #%>%
#>   #kable_styling(latex_options = "striped")


## ----table-methods-static, eval = knitr::is_latex_output(), echo=F, message=FALSE----
Metodo   <- c("\\texttt{hm\\_agg}", 
              "\\texttt{hm\\_build\\_generic}",
              "\\texttt{hm\\_create}", 
              "\\texttt{hm\\_get}",
              "\\texttt{hm\\_melt}",
              "\\texttt{hm\\_mutate}",
              "\\texttt{hm\\_name}", 
              "\\texttt{hm\\_plot}",
              "\\texttt{hm\\_report}",
              "\\texttt{hm\\_set}",
              "\\texttt{hm\\_show}",
              "\\texttt{hm\\_subset}")

Descrip  <- c("temporally aggregates  data",
              "automatically loads raw data inside the \\texttt{hydromet\\_station} object", 
              "constructs the \\texttt{hydromet} class and its subclasses", 
              "extracts the required table (or metadata) from the object",
              "merges several tables into a single one and set it into a \\texttt{hydromet\\_compact} class object",
              "creates, modifies and deletes columns inside an object table (slot)",
              "changes data frame column names",
              "makes static and interactive graphs of the required hydrometeorological variables",
              "gets basic statistic and a table with missing data",
              "assigns the (meta)data to an \\texttt{hydromet} class or subclass object", 
              "shows the head or tail of the tables inside the object",
              "subsets the required table")

df_method <- data.frame(Metodo, Descrip)

colnames(df_method) <- c("Method", "Description")

df_method %>%
  kbl(caption = "Processing operations for object manipulation in the \\pkg{hydrotoolbox} package.",
      booktabs = T,
      escape = F,
      format = "latex") %>% 
  row_spec(0, bold = TRUE) %>% 
  column_spec(column = 1) %>%
  kable_styling(font_size = 9)


## ----read-like, echo = F, fig.show="hold", fig.align="center", out.width="52%", fig.cap= "Rectangular data formats/file types compatible with the $\\texttt{hm\\_build\\_generic}$ function. Top scheme depicts allowed delimited file arrangements while the bottom scheme is for excel files."----
knitr::include_graphics(path = c("./readr_like.png", "./readxl_like.png") )


## ----build-generic, echo=TRUE, eval=FALSE-------------------------------------
#> #* This code example shows how to use
#> #* the hm_build_generic() method to
#> #* automatically load raw hydrometeorological
#> #* data
#> 
#> library(hydrotoolbox)
#> library(readr)
#> library(readxl)
#> 
#> # path to data
#> my_path <- "./home/my_folder/my_data"
#> 
#> #+++++++++++++++++++
#> # Rectangular data
#> #+++++++++++++++++++
#> #* Case B: multiple files (one per variable)
#> hm_create(class_name = "station") %>%
#>  hm_build_generic(path = my_path,
#>                   file_name = c("h_relativa_cuevas.csv",
#>                                 "p_atm_cuevas.csv",
#>                                 "precip_total_cuevas.csv",
#>                                 "temp_aire_cuevas.csv",
#>                                 "vel_viento_cuevas.csv"),
#>                   slot_name = c("rh", "patm", "precip",
#>                                 "tair", "wspd"),
#>                   by = c("hour", "45 min", "30 min", "1 hour", "15 min"),
#>                   FUN = read_csv  ) %>%
#>  hm_show()
#> 
#> 
#> #+++++++++++++++++++
#> # Excel files
#> #+++++++++++++++++++
#> #* Case B: single file - multiple sheets (one per variable)
#> hm_create(class_name = "station") %>%
#>  hm_build_generic(path = my_path,
#>                   file_name = "mnemos_guido.xlsx",
#>                   slot_name = c("qd", "evap",
#>                                 "tair","tmax",
#>                                 "tmin"),
#>                   by = c(q = "day", evap =  "day",
#>                          tair = "6 hour", tmax = "day",
#>                          tmin = NULL),
#>                   FUN = read_excel,
#>                   sheet = c(1L:5L),
#>                   skip = 3,
#>                   out_name = list( c("q_m3/s", "flag"),
#>                                    c("evap_mm", "flag"),
#>                                    c("tair", "flag"),
#>                                    c("tmax", "flag"),
#>                                    c("tmin", "flag")
#>                   )
#>  ) %>%
#>  hm_show()


## ----mza-basin, echo = FALSE, fig.align="center", out.width="60%", fig.pos="h", fig.cap= "Map of the Mendoza basin including Guido hydrological station, cities, river and main mountain summits for reference."----

knitr::include_graphics(path = "./mza_basin.png")



## ----guido-build, echo=TRUE---------------------------------------------------
library(hydrotoolbox)
library(readxl)

# package's data-base
path <- system.file("extdata", package = "hydrotoolbox")

# station building
guido <- 
  hm_create(class_name = "station") %>%
  hm_build_generic(path = path, 
                   file_name = "snih_qd_guido.xlsx", 
                   slot_name = "qd",
                   by = "1 day", 
                   out_name = list("q_m3/s"), 
                   sheet = 1L, 
                   FUN = read_excel)


## ----guido-set-report, echo=TRUE----------------------------------------------
# set the basin area
guido <- 
  guido %>% 
  hm_set(basin_area = 7110)

# get streamflow's report
guido %>% 
  hm_report(slot_name = "qd")


## ----guido-plot-static, eval=knitr::is_latex_output(), echo=T, fig.align="center", out.width="100%", fig.cap = "Plot of the Guido's streamflow time series (hydrologial years 2010/11 to 2013/14)."----
# ggplot2 daily flow
guido %>% 
  hm_plot(slot_name = "qd",
          col_name = list( "q_m3/s" ), 
          interactive = FALSE, 
          line_color = "dodgerblue",
          line_size = .7,
          y_lab = "Q(m3/s)", 
          from = "2010-07-01", 
          to = "2014-06-30") 


## ----guido-plot-html, eval=knitr::is_html_output(), echo=T, fig.align="center", out.width="100%", fig.cap = "Plot of the Guido's streamflow time series (hydrologial year 2010/11 to 2013/14)."----
#> # plotly daily flow
#> guido %>%
#>   hm_plot(slot_name = "qd",
#>           col_name = list( "q_m3/s" ),
#>           interactive = TRUE,
#>           line_color = "dodgerblue",
#>           line_size = .7,
#>           y_lab = "Q(m3/s)",
#>           from = "2010-07-01",
#>           to = "2014-06-30")


## ----guido-smooth, eval=T, echo= T--------------------------------------------
# smooth with roll_fun
guido <- 
  guido %>%
  hm_mutate(slot_name = "qd",
            FUN = roll_fun,
            col_name = "last",
            pos = "c",
            k = 5,
            mean,
            out_name = "q_smooth") 

# remove doubtful records with set_value
guido <- 
  guido %>%
  hm_mutate(slot_name = "qd",
            FUN = set_value,
            col_name = "q_smooth",
            out_name = "q_set",
            value = rep(NA_real_, 2),
            from = c("1965-08-09", "1974-06-26"),
            to = c("1965-08-25", "1974-07-04") )


## ----guido-agg-get, eval=TRUE, echo=TRUE--------------------------------------
# aggregate daily mean streamflow 
# to mean monthly values
guido <- 
  guido %>%
  hm_agg(slot_name = "qd",
         col_name = "q_set", 
         fun = "mean", 
         period = "monthly", 
         out_name = "q_mean", 
         relocate = "qm", 
         allow_na = 2)

# extract the table 
tb_q_month <- 
  guido %>% 
  hm_get(slot_name = "qm")

# extract baisn area
basin_area <- 
  guido %>% 
  hm_get(slot_name = "basin_area")




## ----guido-ggplot, eval=T, echo=T, warning=F, fig.align="center", out.width="100%", fig.cap="Example of customized time-series plot using the $\\texttt{hm\\_plot()}$ method in combination with labeling, scaling and theme options available on $\\textbf{ggplot2}$."----
# library
library(ggplot2)

# plot
gg_hm <-
  guido %>%
    hm_plot(slot_name = "qm", 
          col_name = list( c("q_mean") ), 
          line_color = "dodgerblue",
          line_size = .7,
          y_lab = "Q(m3/s)", x_lab = "", 
          legend_lab = "Mendoza River", 
          from = "1980-07-01", to = "1990-06-30") 
  
 # customize the graph
gg_out <- 
  gg_hm + 
    geom_point(col = "red", size = .8) +
    theme_light() + 
    scale_x_date( date_breaks = "4 month", date_labels = "%Y-%m" ) +
    scale_y_continuous(breaks = seq(0, 300, 50), limits = c(0, 300) ) +
    theme(axis.text = element_text(size = 8),
          axis.title.x = element_text(size = 10, face = "bold"),
          axis.text.x = element_text(angle = 90, vjust = 0.5),
          axis.title.y = element_text(size = 10, face = "bold"), 
          legend.position = "none")
        

gg_out


## ----cuevas-mb, eval=T, echo=T, warning=F, message=F, fig.align="center", out.width="100%", fig.cap="Model post-processing case example for the Cuevas basin annual glacier mass balance."----
# dplyr contains mutate()
library(dplyr) 

# glacier mass balance simulation
cuevas_mb <- readRDS(file = "data/cuevas_mb.rds" )

cuevas_mb <- 
  cuevas_mb %>%
  hm_mutate(slot_name = "compact",
            FUN = mutate, 
            `bm (m we)` = round( cuevas / 1000, 2 ),
            .keep = "all"
            ) 

cuevas_mb %>% hm_show()

# use hm_plot()
gg_out <- 
  cuevas_mb %>% 
  hm_plot(slot_name = "compact", 
          col_name = list("bm (m we)"), 
          line_color = "red3", 
          line_size = .7, 
          x_lab = "", y_lab = "MB (m we)"  )
  
# customize the figure
gg_out + 
geom_point(col = "blue", size = .8) +
  geom_hline(yintercept = 0) +
  theme_light() + 
  scale_x_date( date_breaks = "2 year", date_labels = "%Y" ) +
  scale_y_continuous(breaks = seq(-1.5, 1.5, 0.25),
                     limits = c(-1.5, 1.5) ) +
  theme(axis.text = element_text(size = 8),
        axis.title.x = element_text(size = 10, face = "bold"),
        axis.text.x = element_text(angle = 90, vjust = 0.5),
        axis.title.y = element_text(size = 10, face = "bold"), 
        legend.position = "none") 

