# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit chassagnol-becht-nuel-benchmark-of-Gaussian-mixtures.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
  echo = FALSE,
  warning = FALSE,
  message = FALSE,
  fig.align = "center",
  fig.fullwidth = TRUE,
  message = FALSE,
  warning = FALSE,
  out.width = "100%",
  cache = FALSE, lazy.cache = FALSE
)

library(ggplot2)
library(dplyr)
library(flextable)
library(kableExtra)
library(downlit)
library(RGMMBench)

options(dplyr.summarise.inform = FALSE) # remove the override .groups argument

# rjtools::initial_check_article(".", dic = "en_GB", ignore=c("gmms", "transcriptomic", "gaussian", "heteroscedascity", "equi", "clusterwise", "underbrace", "homoscedascity", "rebmix", "cran", "bioconductor", "mclust", "kd", "st", "th", "homoscedastic", "hyperparameters"))


#> p.caption {
#>   font-size: 0.6em;
#> }
#> 
#> .blackbox {
#>   padding: 1em;
#>   background: #DBDBDB;
#>   color: black;
#>   border: 4px solid black;
#>   border-radius: 10px;
#> }
#> .center {
#>   text-align: center;
#> }
#> 
#> .cols {display: flex; }

## ----flowchart, fig.cap="A minimal roadmap used for the selection of the packages reviewed in our benchmark.", fig.alt="From root to top, we describe schematically the filtering process used for the final selection of the reviewed packages"----
knitr::include_graphics("figures/flowchart_packages_selection.png")


## ----retrieve-general-information, echo=FALSE, eval=FALSE---------------------
#> relevant_packages <- c("EMMIXmfa", "HDclassif")
#> info_package <- relevant_packages %>%
#>   purrr::map_dfr(function(x) {
#>     description <- utils::packageDescription(
#>       pkg = x,
#>       fields = c(
#>         "Package", "Version", "Date", "Maintainer",
#>         "License", "Imports", "Depends", "LinkingTo"
#>       )
#>     )
#>     description_tibble <- tibble::tibble(
#>       Package = description$Package, Version = description$Version, Date = description$Date,
#>       Maintainer = description$Maintainer, License = description$License, Imports = description$Imports,
#>       Depends = description$Depends, LinkingTo = description$LinkingTo
#>     )
#>     return(description_tibble)
#>   })
#> 
#> info_package <- cranlogs::cran_downloads(
#>   package = relevant_packages,
#>   from = "2019-04-01", to = "2023-04-01"
#> ) %>%
#>   dplyr::group_by(package) %>%
#>   dplyr::summarise(Popularity = round(mean(count))) %>%
#>   dplyr::inner_join(info_package, by = c("package" = "Package"))
#> 
#> info_package <- info_package %>% dplyr::inner_join(
#>   purrr::imap_dfr(
#>     tools::package_dependencies(packages = relevant_packages, recursive = TRUE),
#>     ~ tibble::tibble(package = .y, recursive_deps = list(.x))
#>   )
#> )


## ----low-comparison-package-html, layout="l-body-outset", eval = knitr::is_html_output()----
#> readr::read_delim("./tables/package_comparison_low_level.csv", delim = ";", show_col_types = F) %>%
#>   mutate(
#>     Imports = stringr::str_replace(Imports, ">=", "\U2265"),
#>     dplyr::across(.cols = c("Regression", "Implemented models"), ~ gsub(pattern = "redcross", "./figures/red_cross.png", .x)),
#>     dplyr::across(.cols = c("Regression", "Implemented models"), ~ gsub(pattern = "greentick", "./figures/green_tick.png", .x)),
#>     across(.cols = where(is.character), stringr::str_replace_all, "\\\\n", " ")
#>   ) %>%
#>   flextable() %>%
#>   flextable::mk_par(i = 1:9, j = 3, value = as_paragraph(
#>     flextable::as_image(src = Regression, width = 0.5, height = 0.5, unit = "cm")
#>   )) %>%
#>   flextable::mk_par(i = c(1, 4:9), j = 4, value = as_paragraph(
#>     flextable::as_image(src = "./figures/red_cross.png", width = 0.5, height = 0.5, unit = "cm")
#>   )) %>%
#>   set_caption(caption = "Main features of the reviewed packages, sorted by decreasing number
#> of daily downloads. *Downloads per day* returns the daily average number of downloads for each package on the last 2 years.
#>  *Recursive dependencies* column counts the complete set of non-base packages required, as first-order dependencies depend on other packages as well.", html_escape = F) %>%
#>   theme_vanilla() %>%
#>   align(align = "center", part = "header") %>%
#>   flextable::autofit() %>%
#>   flextable::hline(i = 7)


## ----low-comparison-package-pdf, eval = knitr::is_latex_output()--------------
readr::read_delim("./tables/package_comparison_low_level.csv", delim = ";", show_col_types = F) %>%
  mutate(dplyr::across(.cols = c("Regression", "Implemented models"), ~ gsub(pattern = "redcross", "$\\\\redcross$", .x)),
    dplyr::across(.cols = c("Regression", "Implemented models"), ~ gsub(pattern = "greentick", "\\\\greentick", .x)),
    Imports = gsub(pattern = ">=", "$\\\\ge$", Imports),
    across(.cols = where(is.character), kableExtra::linebreak, linebreaker = "\\\\n")
  ) %>%
  kbl(
    booktabs = T, caption = "Main features of the reviewed packages, sorted by decreasing number of daily downloads.
               \\textit{Downloads per day} returns the daily average number of downloads for each package on the last 2 years.
               \\textit{Recursive dependencies} column counts the complete set of non-base packages required,
               as first-order dependencies depend on other packages as well.", escape = F,
    col.names = linebreak(c(
      "Package", "Version",
      "Regression", "Implemented \n models", "Downloads \n per day",
      "Last \n update", "Imports", "Recursive \n dependencies", "Language"
    ))
  ) %>%
  row_spec(0, bold = T, align = "c", hline_after = T) %>%
  row_spec(7, hline_after = T) %>%
  kable_styling(latex_options = c("hold_position", "scale_down"))


## ----high-comparison-packages-html, layout="l-body-outset", eval = knitr::is_html_output()----
#> data <- readr::read_delim("./tables/package_comparison_high_level.csv", delim = ";", show_col_types = F) %>%
#>   filter(!(Column1 %in% c("Labelled data", "Weighted implementation", "Simulation"))) %>%
#>   tibble::column_to_rownames("Column1") %>%
#>   mutate(
#>     dplyr::across(.cols = everything(), ~ gsub(pattern = "redcross", "./figures/red_cross.png", .x)),
#>     dplyr::across(.cols = everything(), ~ gsub(pattern = "greentick", "./figures/green_tick.png", .x))
#>   ) %>%
#>   tibble::rownames_to_column("Package features")
#> 
#> flex_data <- data %>% flextable()
#> for (i in 1:nrow(data)) {
#>   green_index <- grep("green_tick", data[i, ] %>% unlist())
#>   red_index <- grep("red_cross", data[i, ] %>% unlist())
#>   flex_data <- flex_data %>%
#>     flextable::mk_par(
#>       i = i, j = green_index,
#>       value = as_paragraph(flextable::as_image(
#>         src = "./figures/green_tick.png",
#>         width = 0.5, height = 0.5, unit = "cm"
#>       ))
#>     ) %>%
#>     flextable::mk_par(
#>       i = i, j = red_index,
#>       value = as_paragraph(flextable::as_image(
#>         src = "./figures/red_cross.png",
#>         width = 0.5, height = 0.5, unit = "cm"
#>       ))
#>     )
#> }
#> 
#> flex_data %>%
#>   set_caption(
#>     caption = "Custom features associated to GMMs estimation for any of the benchmarked packages.",
#>     html_escape = F
#>   ) %>%
#>   theme_vanilla() %>%
#>   align(align = "center", part = "header") %>% # centre align header
#>   flextable::autofit() %>%
#>   flextable::vline(j = 8, border = officer::fp_border(width = 2))


## ----high-comparison-packages-pdf, eval = knitr::is_latex_output()------------
readr::read_delim("./tables/package_comparison_high_level.csv", delim = ";", show_col_types = F) %>%
  filter(!(Column1 %in% c("Labelled data", "Weighted implementation", "Simulation"))) %>%
  tibble::column_to_rownames("Column1") %>%
  mutate(
    dplyr::across(.cols = everything(), ~ gsub(pattern = "redcross", "\\\\redcross", .x)),
    dplyr::across(.cols = everything(), ~ gsub(pattern = "greentick", "\\\\greentick", .x))
  ) %>%
  kbl(booktabs = T, caption = "Custom features associated to GMMs estimation for any of the benchmarked packages.", escape = F) %>%
  kable_styling(latex_options = c("hold_position", "scale_down")) %>%
  row_spec(0, bold = T, align = "c") %>%
  row_spec(1:7, hline_after = T) %>%
  column_spec(column = 1:10, latex_valign = "m", width = c("1.6cm", "4cm", rep("1.6cm", 9))) %>%
  column_spec(column = 1, bold = T, border_right = T) %>%
  column_spec(column = 8, border_right = T)


## ----general-parameter-description-html, eval=knitr::is_html_output()---------
#> read.table("./tables/general_simulation_parameters.csv", sep = ";", header = T, check.names = F) %>%
#>   flextable() %>%
#>   compose(j = "Criterion threshold", value = as_paragraph(as_equation(`Criterion threshold`, width = 2, height = .5))) %>%
#>   set_caption(caption = "Global options shared by all the benchmarked packages.", html_escape = F) %>%
#>   theme_vanilla() %>%
#>   align(align = "center", part = "header") %>%
#>   flextable::autofit()


## ----general-parameter-description-pdf, eval=knitr::is_latex_output()---------
formatted_data <- readr::read_delim("./tables/general_simulation_parameters.csv", delim = ";") %>%
  dplyr::mutate(`Criterion threshold` = paste0("$", `Criterion threshold`, "$"))


formatted_data %>%
  kbl(booktabs = T, caption = "Global options shared by all the benchmarked packages.", escape = F, midrule = "midrule", align = "c") %>%
  kable_styling(latex_options = c("hold_position", "scale_down")) %>%
  row_spec(0, bold = T) %>%
  row_spec(1, hline_after = T) %>%
  column_spec(1:ncol(formatted_data), width = "4.1cm") %>%
  kable_styling(bootstrap_options = c("striped", "hover", "condensed"))


## ----load-configurations------------------------------------------------------

univariate_configuration <- readRDS("./tables/univariate/univariate_configuration_scenario.rds")
bivariate_configuration <- readRDS("./tables/bivariate/bivariate_configuration_scenario.rds")
HD_configuration <- readRDS("./tables/HD/HD_configuration_scenario.rds")


## ----prepare-legend-final-figure----------------------------------------------
html_ouput <- knitr::is_html_output()
html_final_legend <- paste("Panels A, B and C show respectively the heatmap of the Pearson correlation in the univariate, bivariate and high-dimensional framework between the parameters estimated by the packages, evaluated for the most discriminating and complex scenario. The correlation matrix was computed using the function", downlit::autolink("stats::cor"), "with option *complete* to remove any missing value related to a failed simulation, and the heatmap generated with the Bioconductor package *ComplexHeatmap*.
Panel D represents a tree summarising the main differences between the benchmarked packages, in terms of the EM implementation. They are discussed in more detail in Appendix *EM-implementation differences across reviewed packages*.")

pdf_final_legend <- "Panels A, B and C show respectively the heatmap of the Pearson correlation in the univariate, bivariate and high-dimensional framework between the parameters estimated by the packages, evaluated for the most discriminating and complex scenario. The correlation matrix was computed using the function \\code{stats::cor} with option \\textit{complete} to remove any missing value related to a failed simulation, and the heatmap generated with the Bioconductor package \\BIOpkg{ComplexHeatmap}. Panel D represents a tree summarising the main differences between the benchmarked packages, in terms of the EM implementation. They are discussed in more detail in Appendix \\textit{EM-implementation differences across reviewed packages}."


## ----dichotomy-package-conclusion, fig.cap=if (html_ouput) html_final_legend else pdf_final_legend----
knitr::include_graphics("./figures/dichotomy_package_conclusion.png")


## ----decision-tree-GMMs, fig.cap="A decision tree to select the best combination of package and initialisation method with respect to the main characteristics of the mixture. It's worth pointing that in both univariate and low dimension multivariate settings, the recommandations are similar."----
# decision_tree_univariate <- Node$new("Estimation of the MLE in GMMs")
# separated <- decision_tree_univariate$AddChild("Well-separated components")
# rebmix <- separated$AddChild("Rebmix initialisation")
# overlapping <- decision_tree_univariate$AddChild("Overlapping components")
# balanced <- overlapping$AddChild("Balanced mixture")
# kmeans_balanced <- balanced$AddChild("*k*-means initialisation with \n GMKMcharlie or EMCluster")
# unbalanced_numerous_components <- overlapping$AddChild("Unbalanced and number of clusters \U2265 4")
# unbalanced_variability <- unbalanced_numerous_components$AddChild("Optimise variability and MSE")
# second_class <- unbalanced_variability$AddChild("Second class of packages \n with *k*-means initialisation, \n preferentially with GMKMcharlie \n or EMCluster")
# unbalanced_bias <- unbalanced_numerous_components$AddChild("Optimise bias")
# first_class <- unbalanced_bias$AddChild("First class of packages \n with *k*-means initialisation \n for proportions and variability \n estimations and random \n for centroids estimation")
# unbalanced_few_components <- overlapping$AddChild("Unbalanced and number of clusters < 4")
# decision_unbalanced_few_components <- unbalanced_few_components$AddChild("rebmix or random initialisation \n with the second class of packages.")
#
# # custom the decision tree plot
# SetGraphStyle(decision_tree_univariate, rankdir = "TB", fontSize = 25)
# SetEdgeStyle(decision_tree_univariate, arrowhead = "vee", penwidth = 2)
# SetNodeStyle(decision_tree_univariate, style = "filled,rounded", shape = "box",
#              fontname = "helvetica", tooltip = GetDefaultTooltip)
# # SetNodeStyle(separated, fillcolor = "chartreuse1")
# # SetNodeStyle(overlapping, fillcolor = "crimson")
# Do(decision_tree_univariate$leaves, function(node) SetNodeStyle(node, shape = "egg")) # custom the leaves
#
#
# DiagrammeR::export_graph(ToDiagrammeRGraph(decision_tree_univariate),
#                          "./figures/decision_tree.png", file_type = "png")


knitr::include_graphics("./figures/decision_tree_GMMs.png")


## ----parameter-configuration-univariate, layout = "l-body-outset"-------------
univariate_configuration %>%
  mutate(
    Proportions = purrr::map_chr(true_parameters, ~ paste(.x$p, collapse = " / ")),
    Means = purrr::map_chr(true_parameters, ~ paste(.x$mu, collapse = " / ")),
    Correlations = purrr::map_chr(true_parameters, ~ paste(.x$sigma, collapse = " / "))
  ) %>%
  select(-c("OVL", "prop_outliers", "true_parameters", "formatted_true_parameters", "old_OVL")) %>%
  rename(Entropy = entropy, OVL = OVL_pairwise) %>%
  kbl(
    booktabs = T, caption = "The 9 parameter configurations tested to generate the samples of the univariate experiment, with $k=4$ components.",
    escape = F, align = "c"
  ) %>%
  kable_styling(latex_options = c("hold_position", "scale_down")) %>%
  row_spec(0, bold = T) %>%
  row_spec(1:9, hline_after = T) %>%
  kable_styling(bootstrap_options = c("hover", "condensed"))


## ----parameter-configuration-bivariate, layout = "l-body-outset"--------------
bivariate_configuration %>%
  mutate(
    Proportions = purrr::map_chr(true_parameters, ~ paste(.x$p, collapse = " / ")),
    Means = purrr::map_chr(true_parameters, ~ paste0("(", paste0(.x$mu[, 1], collapse = ","), ");(", paste0(.x$mu[, 2], collapse = ","), ")")),
    Correlations = purrr::map_chr(true_parameters, ~ paste(c(.x$sigma[1, 2, 1], .x$sigma[1, 2, 2]), collapse = " / "))
  ) %>%
  select(-c("OVL", "nobservations", "prop_outliers", "true_parameters", "formatted_true_parameters", "true_parameters_factor")) %>%
  rename(Entropy = entropy, OVL = OVL_pairwise) %>%
  kbl(
    booktabs = T, caption = "The 20 parameter configurations tested to generate the samples of the bivariate experiment.",
    escape = F, align = "c"
  ) %>%
  kable_styling(latex_options = c("hold_position", "scale_down")) %>%
  row_spec(0, bold = T) %>%
  row_spec(1:20, hline_after = T) %>%
  kable_styling(bootstrap_options = c("hover", "condensed"))


## ----parameter-configuration-HD, layout = "l-body-outset"---------------------
HD_configuration_formatted <- HD_configuration %>%
  rename(Entropy = entropy, Spherical = is_diagonal, `Number of observations` = nobservations) %>%
  mutate(
    Proportions = purrr::map_chr(true_parameters, ~ paste(round(.x$p, digits = 2), collapse = " / ")),
    Spherical = dplyr::if_else(Spherical, "\\greentick", "\\redcross"), ID = paste0("HD", ID)
  ) %>%
  select(-c("true_parameters", "Entropy")) %>%
  dplyr::relocate(Spherical, .after = Proportions)


HD_configuration_formatted %>%
  kbl(
    booktabs = T, caption = "The 16 parameter configurations tested to generate the samples in a high dimensional context. The first digit of each ID index refers
      to an unique parameter configuration (identified by its level of overlap, entropy and topological structure, either circular or ellipsoidal,
      of the covariance matrix, while the lowercase letter depicts the number of observations, a) with $n=200$ and b) with $n=2000$.",
    escape = F, align = "c",
    col.names = linebreak(c("ID", "OVL", "Number of \nobservations", "Proportions", "Spherical"))
  ) %>%
  kable_styling(latex_options = c("hold_position", "scale_down")) %>%
  row_spec(0, bold = T) %>%
  row_spec(1:16, hline_after = T) %>%
  kable_styling(bootstrap_options = c("hover", "condensed"))

