# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit IVHet.Rmd to modify this file

## ----tenure-data, message = FALSE---------------------------------------------
tenure_data <- read.csv(file = 'tenure.csv')


## ----logit--------------------------------------------------------------------
sub_data <- subset(tenure_data, year <= 10)
logit_m <- glm(tenure ~  year + I(year^2) + select + articles + prestige, 
               subset = (female == 0),
               data   = sub_data,
               family = binomial(link = "logit"))
logit_w <- glm(tenure ~  year + I(year^2) + select + articles + prestige, 
               subset = (female == 1), 
               data   = sub_data, 
               family = binomial(link = "logit"))


## ----table-logit, message = FALSE, warning=FALSE------------------------------
library("memisc")
mtable("Logit for men" = logit_m,
       "Logit for women" = logit_w, 
       summary.stats = c("Log-likelihood", "AIC", "BIC", "N"))


## ----het.logit, message = FALSE-----------------------------------------------
library("Rchoice")
het_logit <- hetprob(tenure ~ factor(female) + year + I(year^2) + select +  
                       articles + prestige | factor(female), 
                     data = sub_data, 
                     link = "logit")


## ----sum.het.logit------------------------------------------------------------
summary(het_logit)


## ----hetglm-------------------------------------------------------------------
library("glmx")
het_glmx <- hetglm(tenure ~ factor(female) + year + I(year^2) + select +  
                       articles + prestige | factor(female), 
                     data = sub_data, 
                    family = binomial(link = "logit"))
summary(het_glmx)

## ----table-het1---------------------------------------------------------------
mtable("Logit for men"   = logit_m,
       "Logit for women" = logit_w, 
       "Heteroskedastic" = het_logit,
       summary.stats = c("Log-likelihood", "AIC", "BIC", "N"))


## ----allinson-delta-----------------------------------------------------------
sigma_w <- exp(coef(het_logit)["het.factor(female)1"])
(1 -  sigma_w) / sigma_w


## ----allinson-delta-ci, message = FALSE---------------------------------------
library("car")
sharef <- "(1 - exp(`het.factor(female)1`)) / exp(`het.factor(female)1`)"
deltaMethod(het_logit, sharef)


## ----interaction--------------------------------------------------------------
het_logit2 <- hetprob(tenure ~ factor(female) + year + I(year^2) + select +  
                        articles + prestige + factor(female)*articles | 
                        factor(female), 
                      data = sub_data, 
                      link = "logit")
print(summary(het_logit2), digits = 3)


## ----plothet, fig.cap = "Distribution of predicted probability and predicted sigma", fig.width=6, fig.height=3.5----
par(mfrow = c(1, 2))
hist(predict(het_logit2, type = "pr"), 
     main = "Predicted probabilities", 
     xlab = "Probabilities")
hist(predict(het_logit2, type = "sigma"), 
     main = "Predicted sigma", 
     xlab = "Sigma")


## ----het.me-------------------------------------------------------------------
eff_logit  <- effect(het_logit2)
het_probit <- hetprob(tenure ~ factor(female) + year + I(year^2) + select +  
                        articles + prestige + factor(female)*articles | 
                        factor(female),              
                      data = sub_data,                        
                      link = "probit")
eff_probit <- effect(het_probit)
mtable(eff_probit,
       eff_logit)


## ----load-mroz----------------------------------------------------------------
mroz <- read.csv(file = 'mroz.csv')
mroz$kids <- with(mroz, factor((kidslt6 + kidsge6) > 0,
                               levels = c(FALSE, TRUE), 
                               labels = c("no", "yes")))
mroz$finc <-  mroz$faminc / 10000


## ----greene-17----------------------------------------------------------------
labor_hom <- glm(inlf ~  age + I(age^2) + finc + educ + factor(kids), 
                 data = mroz, 
                 family = binomial(link = "probit"))
labor_het <- hetprob(inlf ~  age + I(age^2) + finc + educ + factor(kids) | 
                       factor(kids) + finc,              
                     data = mroz,                        
                     link = "probit")
eff_labor_het <- effect(labor_het)
mtable(labor_hom,
       labor_het,
       eff_labor_het)


## ----test-homokedasticity-----------------------------------------------------
coefs <- names(coef(labor_het))
linearHypothesis(labor_het, coefs[grep("het", coefs)])


## ----probit-nwincome----------------------------------------------------------
probit <- glm(inlf ~  educ + exper + I(exper^2) + age + kidslt6 + kidsge6 + nwifeinc, 
              data = mroz, 
              family = binomial(link = "probit"))
ape.probit <- mean(dnorm(predict(probit, type = "link"))) * coef(probit)["nwifeinc"]
ape.probit


## ----margins------------------------------------------------------------------
library("marginaleffects")
avg_slopes(probit, variables = "nwifeinc")


## ----iv-first-step------------------------------------------------------------
fstep   <- lm(nwifeinc ~ educ + exper + I(exper^2) + age + kidslt6 + kidsge6  + huseduc, 
            data = mroz)
mroz$res.hat <- fstep$residuals


## ----F-test-------------------------------------------------------------------
linearHypothesis(fstep, "huseduc")


## ----iv-second-step-----------------------------------------------------------
sstep   <- glm(inlf ~  educ + exper + I(exper^2) + age + kidslt6 + kidsge6 + nwifeinc + res.hat, 
            data   = mroz, 
            family = binomial(link = "probit")) 
summary(sstep)


## ----compute-rho--------------------------------------------------------------
lambda.hat    <- coef(sstep)["res.hat"]
k             <- length(fstep$coefficients)
SSE           <- sum(fstep$residuals^2)
n             <- length(fstep$residuals)
sigma.upsilon <- sqrt(SSE/(n - k))
rho.hat       <- lambda.hat * sigma.upsilon
rho.hat


## ----ivprobit-function--------------------------------------------------------
library("ivprobit")
twostep.probit <- ivprobit(inlf ~  educ + exper + I(exper^2) + age + kidslt6 + kidsge6 | 
                             nwifeinc | educ + exper + I(exper^2) + age + kidslt6 + 
                             kidsge6 + huseduc, 
                           data = mroz)
summary(twostep.probit)


## ----ape----------------------------------------------------------------------
ape <- function(data, indices){
  d <- data[indices, ]
  # Compute the first-stage regression
  fstep    <- lm(nwifeinc ~ educ + exper + I(exper^2) + age + kidslt6 + kidsge6 + 
                   huseduc, 
                 data = d)
  # Obtain the residuals 
  d$res.hat <- fstep$residuals
  # Compute the second-stage regression
  sstep   <- glm(inlf ~  educ + exper + I(exper^2) + age + kidslt6 + kidsge6 + 
                   nwifeinc + res.hat, 
                 data   = d, 
                 family = binomial(link = "probit"))
  # Compute APE for nwincome
  out <- mean(dnorm(predict(sstep, type = "link"))) * coef(sstep)["nwifeinc"]
  return(out)
}


## ----boot, message = FALSE----------------------------------------------------
library("boot")
set.seed(666)
results <- boot(data = mroz, statistic = ape, R = 500)
results
boot.ci(results, type = "norm", conf = 0.90)


## ----unscaledpar--------------------------------------------------------------
coef(sstep) * sqrt(1 - rho.hat^2)


## ----fiml---------------------------------------------------------------------
fiml.probit <- ivpml(inlf ~  educ + exper + I(exper^2) + age + kidslt6 + kidsge6 + 
                       nwifeinc | huseduc +  educ + exper + I(exper^2) + age + 
                       kidslt6 + kidsge6, 
                     data = mroz)


## ----summary-ivpml------------------------------------------------------------
summary(fiml.probit)


## ----rho-sigma----------------------------------------------------------------
deltaMethod(fiml.probit, "exp(lnsigma)")
deltaMethod(fiml.probit, "tanh(atanhrho)")


## ----rho-sigma-stata----------------------------------------------------------
cbind(exp(coef(fiml.probit)["lnsigma"] - qnorm(0.975) * stdEr(fiml.probit)["lnsigma"]), 
      exp(coef(fiml.probit)["lnsigma"] + qnorm(0.975) * stdEr(fiml.probit)["lnsigma"]))
cbind(tanh(coef(fiml.probit)["atanhrho"] - qnorm(0.975) * stdEr(fiml.probit)["atanhrho"]), 
      tanh(coef(fiml.probit)["atanhrho"] + qnorm(0.975) * stdEr(fiml.probit)["atanhrho"]))


## ----effect.ivpml-------------------------------------------------------------
summary(effect(fiml.probit))
summary(effect(fiml.probit, asf = FALSE))
