# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit vivid.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
library("knitr")
knitr::opts_chunk$set(
  fig.align = "center",
  fig.retina=5,
  echo = FALSE,
  warning = FALSE,
  message = FALSE
)


library("vivid") # for visualizations
library("randomForest") # to create model
library("xgboost") # to create model
library("ggplot2") # for visualizations
library("MASS") # for data
library("tibble") # for creating tables
library("kableExtra") # for creating tables


## ----echo=F-------------------------------------------------------------------
tab1html <- tribble(~Package, ~Description, ~VIVI, ~Measure, ~Method, 
                '<a href = "https://cran.r-project.org/web/packages/vip/index.html">vip</a>', "A general framework for analyzing the behavior of ML models. Also provides PDP based importance and ability to plot Shapley values. Built with ggplot2" , "Both", "Agnostic", "Global",
                '<a href = "https://cran.r-project.org/web/packages/iml/index.html">iml</a>',   "A general framework for analyzing the behavior of ML models. Ability to create lollipop, dot, and barplots. Also includes univariate and bivariate PDPs, ICE curves, LIME, and Shapley visualizations. Built with ggplot2.",  "Both",  "Agnostic", 'Both', 
                '<a href = "https://cran.r-project.org/web/packages/flashlight/index.html">flashlight</a>' , 'A general framework for analyzing the behavior of ML models. Ability to plot VIVI measures using barplots. Includes univariate and bivariate PDPs, ICE curves, Global surrogate, and SHAP visualizations. Built with ggplot2.' , 'Both' , 'Agnostic' , 'Global' ,
                '<a href = "https://cran.r-project.org/web/packages/DALEX/index.html">DALEX</a>' , 'A general framework for analyzing the behavior of ML models. Contains a suite of visualizations including Ceteris Paribus, Shapley, PDPs, model performance, and diagnostic plots. Built with ggplot2.' , 'Both' , 'Agnostic' ,'Both',
                '<a href = "https://cran.r-project.org/web/packages/lime/index.html">lime</a>'  , 'A general framework for fitting a local interpretable model. Ability to create VImp and model visualizations using barplots and heatmaps. Can also create interactive plots. Built with ggplot2.', 'VImp' , 'Agnostic' ,'Local',
                '<a href = "https://cran.r-project.org/web/packages/pdp/index.html">pdp</a>' , 'A general framework for constructing PDPs from various types machine  learning models, bivariate, and  trivariate PDPs and ICE curves.  Built with ggplot2.' , 'VInt' , 'Agnostic' ,'Global',
                '<a href = "https://cran.r-project.org/web/packages/ICEbox/index.html">ICEbox</a>' ,  'Used to create Individual Conditional Expectation (ICE) plots.  Provides univariate and bivariate  PDPs and ICE curves.  Built with ggplot2.' , 'VInt' , 'Agnostic' ,'Local',
                '<a href = "https://cran.r-project.org/web/packages/randomForestExplainer/index.html">randomForestExplainer</a>' , 'Contains a set of model-specific tools to determine which random forests variables are most important. Ability to create VIVI plots displaying the mean minimal depth distribution and conditional minimal depth. Can also display multi-way importance, pairs plots containing different metrics, and Bivariate PDP. Built with ggplot2.', 'Both' , 'Specific' ,'Global',
                '<a href = "https://cran.r-project.org/web/packages/randomForest/index.html">randomForest</a>' , ' Used to build random forest models. Offers VImp, error rate, and univariate PDPs. Built using base R.' , 'VImp' , 'Specific' ,'Global',
                '<a href = "https://cran.r-project.org/web/packages/EIX/index.html">EIX</a>' , 'Contains a set of model-specific tools to determine which GBM variables are most important. Ability to create VIVI plots using lollipops, barplots, and heatmaps. Can also display dot and radar plots. Built with ggplot2. ', 'Both' , 'Specific' ,'Global',
                '<a href = "https://cran.r-project.org/web/packages/varImp/index.html">varImp</a>' , 'Computes random forest VImps for the conditional inference random forest of the party package.', 'Vimp'  , 'Specific','Global',
                '<a href = "https://cran.r-project.org/web/packages/bartMachine/index.html">bartMachine</a>' , 'Used to build Bayesian additive regression tree models. Ability to plot VIVI measures with uncertainty included using barplots. Also includes a suite of model diagnostic  plots and univariate PDP. Built using  base R.' , 'Both' , 'Specific'  ,'Global')
tab1caption <- "Summary of a selection of R packages that can be used to assess the variable importance, variable interactions, or partial dependence and if these metrics are global or local and model-specific or model-agnostic. A brief description of available visualizations for evaluating model behavior is also provided."


## ----echo=F-------------------------------------------------------------------
tab1pdf <- tribble(~Package, ~Description, ~VIVI, ~Measure, ~Method, 
                '\\CRANpkg{vip}', "A general framework for analyzing the behavior of ML models. Also provides PDP based importance and ability to plot Shapley values. Built with \\CRANpkg{ggplot2}.", "Both", "Agnostic", "Global",
                "\\CRANpkg{iml}",   "A general framework for analyzing the behavior of ML models. Ability to create lollipop, dot, and barplots. Also includes univariate and bivariate PDPs, ICE curves, LIME, and Shapley visualizations. Built with \\CRANpkg{ggplot2}.",  "Both",  "Agnostic", 'Both', 
                '\\CRANpkg{flashlight}' , 'A general framework for analyzing the behavior of ML models. Ability to plot VIVI measures using barplots. Includes univariate and bivariate PDPs, ICE curves, Global surrogate, and SHAP visualizations. Built with \\CRANpkg{ggplot2}.' , 'Both' , 'Agnostic' , 'Global' ,
                ' \\CRANpkg{DALEX}' , 'A general framework for analyzing the behavior of ML models. Contains a suite of visualizations including Ceteris Paribus, Shapley, PDPs, model performance, and diagnostic plots. Built with \\CRANpkg{ggplot2}.' , 'Both' , 'Agnostic' ,'Both',
                '\\CRANpkg{lime}'  , 'A general framework for fitting a local interpretable model. Ability to create VImp and model visualizations using barplots and heatmaps. Can also create interactive plots. Built with \\CRANpkg{ggplot2}.', 'VImp' , 'Agnostic' ,'Local',
                '\\CRANpkg{pdp}' , 'A general framework for constructing PDPs from various types machine  learning models, bivariate, and  trivariate PDPs and ICE curves.  Built with \\CRANpkg{ggplot2}.' , 'VInt' , 'Agnostic' ,'Global',
                ' \\CRANpkg{ICEbox} ' ,  'Used to create Individual Conditional Expectation (ICE) plots.  Provides univariate and bivariate  PDPs and ICE curves.  Built with \\CRANpkg{ggplot2}.' , 'VInt' , 'Agnostic' ,'Local',
                '\\CRANpkg{randomForestExplainer}' , 'Contains a set of model-specific tools to determine which random forests variables are most important. Ability to create VIVI plots displaying the mean minimal depth distribution and conditional minimal depth. Can also display multi-way importance, pairs plots containing different metrics, and Bivariate PDP. Built with \\CRANpkg{ggplot2}.', 'Both' , 'Specific' ,'Global',
                '\\CRANpkg{randomForest}' , ' Used to build random forest models. Offers VImp, error rate, and univariate PDPs. Built using base R.' , 'VImp' , 'Specific' ,'Global',
                '\\CRANpkg{EIX}' , 'Contains a set of model-specific tools to determine which GBM variables are most important. Ability to create VIVI plots using lollipops, barplots, and heatmaps. Can also display dot and radar plots. Built with \\CRANpkg{ggplot2}. ', 'Both' , 'Specific' ,'Global',
                '\\CRANpkg{varImp}' , 'Computes random forest VImps for the conditional inference random forest of the \\CRANpkg{party} package.', 'Vimp'  , 'Specific','Global',
                '\\CRANpkg{bartMachine}' , 'Used to build Bayesian additive regression tree models. Ability to plot VIVI measures with uncertainty included using barplots. Also includes a suite of model diagnostic  plots and univariate PDP. Built using  base R.' , 'Both' , 'Specific'  ,'Global')
tab1caption <- "Summary of a selection of R packages that can be used to assess the variable importance, variable interactions, or partial dependence and if these metrics are global or local and model-specific or model-agnostic. A brief description of available visualizations for evaluating model behavior is also provided."


## ----eval=knitr::is_latex_output()--------------------------------------------
kbl(tab1pdf, booktabs = T, escape=F, caption=tab1caption, format="latex")|>
  kable_styling(latex_options = "striped", font_size = 7) |> 
  column_spec(1, bold = T) |> 
  column_spec(2, width = "20em")  |> 
  column_spec(3, width = "4em") |> 
  column_spec(4, width = "4em") |> 
  column_spec(5, width = "4em")


## ----eval=knitr::is_html_output()---------------------------------------------
#>  # kbl(tab1, booktabs = T, escape=F, caption=tab1caption, format="html")|>
#>  #   kable_styling(full_width = T) |>
#>  #   column_spec(1, bold = T,)
#> 
#> DT::datatable(tab1html, caption = tab1caption, escape = FALSE,  autoHideNavigation=TRUE,
#>               rownames=FALSE,options = list(pageLength = nrow(tab1html)))


## ----echo=F-------------------------------------------------------------------
tab2pdf <- tribble(~Function, ~Description, ~Type,
                "\\texttt{vivi}",  "Create a VIVI matrix of class  \\texttt{vivid}", "VIVI construction", 
                "\\texttt{viviReorder}", "Reorders a square matrix so high VIVI values are pushed to the top left of the matrix", "VIVI construction",
                 '\\texttt{viviHeatmap}', 'Heatmap plot of VIVI values', 'Visualization' ,
                 '\\texttt{viviNetwork}' , 'Network plot of VIVI values', 'Visualization' ,
                 '\\texttt{pdpVars}' , 'Univariate partial dependence plot with ICE curves  displayed as a grid', 'Visualization'  ,
                 '\\texttt{pdpPairs}', 'Pairs plot showing bivariate PDP, ICE/univariate PDP,  and data' , 'Visualization' ,
                 '\\texttt{pdpZen}', 'A zigzag expanded navigation plot (zenplot) displaying partial dependence values' , 'Visualization' ,
                 '\\texttt{CVpredictfun}' , 'Predict function' , 'Utility' ,
                 '\\texttt{zPath}', 'Constructs a zenpath for connecting and displaying pairs  to be used with pdpZen', 'Utility'  ,
                 '\\texttt{as.data.frame.vivid}' , 'Takes a matrix of class vivid and turns it into a data frame', 'Utility'  ,
                 '\\texttt{vip2vivid}' , 'Takes measured importance and interactions from the vip  package and turns them into vivid matrix which can be  used for plotting', 'Utility')
tab2cap <- "Summary of functions available in the vivid package. 
The main construction function is \\texttt{vivi} which is used to calculate the VIVI values 
for subsequent use in the visualizations."


## ----echo=F-------------------------------------------------------------------
tab2html <- tribble(~Function, ~Description, ~Type,
                "<tt>vivi</tt>",  "Create a VIVI matrix of class  <tt>vivid</tt>", "VIVI construction", 
                "<tt>viviReorder</tt>", "Reorders a square matrix so high VIVI values are pushed to the top left of the matrix", "VIVI construction",
                 '<tt>viviHeatmap</tt>', 'Heatmap plot of VIVI values', 'Visualization' ,
                 '<tt>viviNetwork</tt>' , 'Network plot of VIVI values', 'Visualization' ,
                 '<tt>pdpVars</tt>' , 'Univariate partial dependence plot with ICE curves  displayed as a grid', 'Visualization'  ,
                 '<tt>pdpPairs</tt>', 'Pairs plot showing bivariate PDP, ICE/univariate PDP,  and data' , 'Visualization' ,
                 '<tt>pdpZen</tt>', 'A zigzag expanded navigation plot (zenplot) displaying partial dependence values' , 'Visualization' ,
                 '<tt>CVpredictfun</tt>' , 'Predict function' , 'Utility' ,
                 '<tt>zPath</tt>', 'Constructs a zenpath for connecting and displaying pairs  to be used with pdpZen', 'Utility'  ,
                 '<tt>as.data.frame.vivid</tt>' , 'Takes a matrix of class vivid and turns it into a data frame', 'Utility'  ,
                 '<tt>vip2vivid</tt>' , 'Takes measured importance and interactions from the vip  package and turns them into vivid matrix which can be  used for plotting', 'Utility')
tab2cap <- "Summary of functions available in the vivid package. 
The main construction function is vivi which is used to calculate the VIVI values 
for subsequent use in the visualizations."


## ----eval=knitr::is_latex_output()--------------------------------------------
kbl(tab2pdf, booktabs = T, escape=F, caption=tab2cap, format="latex")|>
  kable_styling(latex_options = "striped", font_size = 8) |> 
  column_spec(1, bold = F) |> 
  column_spec(2, width = "20em")  |> 
  column_spec(3, width = "10em")


## ----eval=knitr::is_html_output()---------------------------------------------
#> DT::datatable(tab2html, caption = tab2cap, escape = FALSE, autoHideNavigation=TRUE,
#>               rownames=FALSE,
#>               options = list(pageLength = nrow(tab2html)))


## ----rf, echo=TRUE------------------------------------------------------------
library("randomForest") 
library("MASS")
set.seed(1701)  
data("Boston")

rf <- randomForest(medv ~., data = Boston)


## ----xgboost, echo=TRUE-------------------------------------------------------
library("xgboost") 
gbst <- xgboost(data = as.matrix(Boston[,1:13]), 
                label =  as.matrix(Boston[,14]),
                nrounds = 100,
                verbose = 0)


## ----vivirf, echo=TRUE, eval = FALSE------------------------------------------
#> library("vivid")
#> 
#> set.seed(1701)
#> viviRf <- vivi(fit = rf,
#>                data = Boston,
#>                response = "medv",
#>                reorder = FALSE,
#>                normalized = FALSE,
#>                importanceType = "agnostic",
#>                gridSize = 50,
#>                nmax = 500,
#>                class = 1,
#>                predictFun = NULL,
#>                numPerm = 4)


## ----vivirf_data, echo = FALSE------------------------------------------------
# As per instructions, this loads the output of the previous code block called 'vivirf'. 
# This was done as the previous code block was too slow to evaluate.
load("viviRf.RData") 


## ----echo=TRUE----------------------------------------------------------------
# predict function for GBM
pFun <- function(fit, data, ...) predict(fit, as.matrix(data[,1:13]))


## ----vivigbm, echo=TRUE-------------------------------------------------------
set.seed(1701) 
viviGBst <- vivi(fit = gbst,
                 data = Boston,
                 response = "medv",
                 reorder = FALSE,
                 normalized = FALSE,
                 predictFun = pFun)


## ----speedtest, echo=FALSE,   out.width = '60%', fig.cap = "Mean time over five runs, on two MacBooks, for the creation of a vivid matrix for different models. Times are highly dependent on the model fit, with NN the fastest and random forests the slowest."----
knitr::include_graphics("speedTestsplot.png")


## ----vip,  echo=TRUE, eval=FALSE----------------------------------------------
#> library("vip")
#> # get model specific VImps using vip package
#> vipVImp <- vi(rf, method = 'model')
#> # get VInts using vip package
#> vipVInt <- vint(rf, feature_names = names(Boston[-14]))
#> 
#> # turn into vivi-matrix
#> vipViviMat <- vip2vivid(importance = vipVImp, interaction = vipVInt)


## ----avgMatrix, echo=TRUE-----------------------------------------------------
# average over matrices and seriate to get common ordering
viviAvg <- (viviRf + viviGBst) / 2
viviAvgReorder <- vividReorder(viviAvg)

# reorder vivi-matrices 
ord <- colnames(viviAvgReorder)
viviRf <- viviRf[ord,ord]
viviGBst <- viviGBst[ord,ord]


## ----heatmaps,  echo=TRUE,fig.subcap = c("", ""), out.width="50%", fig.cap = "Agnostic variable importance and variable interaction scores for a random forest fit in (a) and GBM fit in (b) on the Boston housing data displayed as a heatmap. The random forest fit has weaker interactions and lower importance scores than the GBM fit. Both fits identify $lstat$ as the most important followed by $rm$. In both fits, $lstat$ has numerous interactions with other variables, notably $crim$ in the random forest fit and $nox$ in the GBM fit."----
viviHeatmap(viviRf, angle = 45, intLims = c(0,1), impLims = c(0,8))
viviHeatmap(viviGBst, angle = 45, intLims = c(0,1), impLims = c(0,8))



## ----networks1, echo = TRUE, fig.subcap = c("", ""), out.width="50%", fig.cap = "Network plots showing VIVI scores obtained from a GBM fit on the Boston housing data. In (a) we display the all values in a circle. In (b) we use a hierarchical clustering to group variable with high VIVI together and rearrange the layout using an igraph function."----

# default network plot for GBM
viviNetwork(viviGBst)

# clustered and filtered network for GBM
intVals <- viviGBst
diag(intVals) <- NA 

# select VIVI values in top 10%
impTresh <- quantile(diag(viviGBst),.9)
intThresh <- quantile(intVals,.9,na.rm=TRUE)
sv <- which(diag(viviGBst) > impTresh |
              apply(intVals, 1, max, na.rm=TRUE) > intThresh)
              
h <- hclust(-as.dist(viviGBst[sv,sv]), method = "single")

viviNetwork(viviGBst[sv,sv],
            intLims = c(0,1),
            impLims = c(0,8),
            cluster = cutree(h, k = 3), # specify number of groups
            layout = igraph::layout_as_star)



## ----dataframe, echo=TRUE-----------------------------------------------------
class(viviRf)<- c("vivid", class(viviRf)) 
head(as.data.frame(viviRf), 4)


## ----pdpRf,echo = TRUE,  out.width="100%", fig.width=10, fig.height=3,fig.cap = "Partial dependence plots (black line) with individual conditional expectation curves (colored lines) of a GBM fit on the Boston housing data. The changing partial dependence and ICE curves of $lstat$ and $rm$ indicate that these variables have some impact on the response."----
top5 <- colnames(viviGBst)[1:5]
pdpVars(data = Boston,
        fit = gbst,
        response = "medv",
        vars = top5,
        predictFun = pFun)


## ----gpdp, echo = TRUE, out.width="75%", fig.width=5, fig.height=4, fig.align='center', fig.cap = "Filtered generalized pairs partial dependence plot for a GBM fit on the Boston housing data. From both the univariate and bivariate PDPs, we can see that $lstat$ and $rm$ have an impact on the response. As $lstat$ decreases and $rm$ increases, predicted median house price value goes up. The bivariate PDP of $lstat:nox$ shows that as $nox$ increases, the predicted value decreases."----


set.seed(1701)
pdpPairs(data = Boston,
         fit = gbst,
         response = "medv",
         gridSize = 20,
         nIce = 50,
         vars = top5,
         convexHull = TRUE,
         fitlims = "pdp",
         predictFun = pFun)


## ----zpdpGbm1, echo = TRUE, out.width="50%", fig.width=3, fig.height=2, fig.align='center', fig.cap = "Zen partial dependence plot for the GBM fit on the Boston data. Here we display first five variables from the GBM's `vivid` matrix. Only plots for consecutive variables are shown."----

pdpZen(data = Boston,
       fit = gbst,
       response = "medv",
       convexHull = TRUE,
       zpath = top5,
       predictFun = pFun)


## ----echo=TRUE----------------------------------------------------------------
intThresh <- quantile(intVals, .9, na.rm=TRUE)
# set zpaths with different parameters
zpGw  <- zPath(viv = viviGBst, cutoff = intThresh, method = "greedy.weighted")
zpGw
zpSw  <- zPath(viv = viviGBst, cutoff = intThresh, connect = FALSE, method = "strictly.weighted")
zpSw


## ----zpdpGBM, echo = TRUE, fig.subcap = c("", ""), out.width="50%", fig.height = 5, fig.width = 3, fig.cap = "ZPDP for a GBM fit on the Boston data. In (a) the zpath is defined by the `greedy.weighted` sorting method. In (b), the sorting method is defined by the `strictly.weighted` method and is unconnected. For low values of $lstat$ and and high values of $rm$, predicted median house price value increases."----

pdpZen(data = Boston,
       fit = gbst,
       response = "medv",
       zpath = zpGw,
       convexHull = TRUE,
       predictFun = pFun) 

pdpZen(data = Boston,
       fit = gbst,
       response = "medv",
       zpath = zpSw,
       convexHull = TRUE,
       predictFun = pFun)


