# Generated by `rjournal_article()` using `knitr::purl()`: do not edit by hand
# Please edit udias-angel.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE, fig.pos = 'H')
library(GREENeR)
library(dplyr)
library(kableExtra)


## ----schematic-diagram-GREENeR, out.width = "90%", out.height = "60%", fig.cap = "Schematic diagram of the procedure of GREENeR including functions, data inputs and outputs, to estimate the nutrient loads according to the GREEN model. The green boxes represent data objects, the blue boxes represent the functions."----
knitr::include_graphics("figures/fig1.png")


## ----maps-TN, out.width = "100%", out.height = "35%", fig.cap = "Maps showing the average TN inputs in the Vistula basin in 1990-2018. The figure was generated with GREENeR input\\_maps() function. Tot.Diff = sum of diffuse inputs.", fig.alt="Maps showing the average TN inputs in the Vistula basin in 1990-2018. The figure was generated with GREENeR input\\_maps() function. Tot.Diff = sum of diffuse inputs."----
knitr::include_graphics("figures/fig2.png")


## ----computational-requirements, eval=knitr::is_html_output()-----------------
#> 
#> knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
#> cr <- data.frame(
#>   basinName = c("Lay", "Miño", "Seine", "Ebro", "Vistula", "Danube"),
#>   shereveOrder = c(95, 2803, 2902, 9351, 7757, 69505),
#>   area = c(1971, 16985, 75989, 85611, 193894, 802032),
#>   numerCatchments = c(189, 5572, 5793, 18568, 15465, 138013),
#>   mem = c(0.5, 15.7, 16.3, 52.3, 43.6, 388.6),
#>   greenCPU1 = c(6, 57, 77, 160, 132, 1120),
#>   greenCPU2 = c(4, 45, 55, 123, 100, 766),
#>   greenSharesCPU1 = c(15, 147, 177, 425, 314, 2855),
#>   greenSharesCPU2 = c(12, 90, 106, 224, 187, 1108),
#>   calibGreenCPU1 = c(316, 4110, 6320, 10876, 9004, 94682),
#>   calibGreenCPU2 = c(31, 394, 452, 995, 814, 5638)
#>   )
#> 
#> cap = "Computational requirements for 6 European basins scenarios of 29 years. The columns Shreve order, Area and Number of catchment measure the size of each basin. Mem is the amount of memory occupied by the GREEN model scenario generated by \\pkg{GREENeR} package. The green(), green_shares() and calib_green() columns show the computation time required to execute the corresponding \\pkg{GREENeR} functions for each of the scenarios under two computer configuration, CPU1, CPU2 (explanation in the text). All runs of calib_green() have been performed with 200 iterations.Values are the average of 5 runs of each process."
#> 
#> 
#> kbl(cr, booktabs = T, format = "html",
#>     caption = cap,
#>     col.names = c("Basin\nname", "Shreve\norder", "Area\nkm$^2$", "Number of\ncatchments", "Mem\nMB",
#>                   "CPU1\nsec", "CPU2\nsec","CPU1\nsec", "CPU2\nsec","CPU1\nsec", "CPU2\nsec" )) %>%
#>   kable_styling() %>%
#>   add_header_above(c(" " = 5, "green()" = 2, "green_shares()" = 2, "calib_green()" = 2))


## ----read-NSdata-function, eval=FALSE, warning=FALSE, message=FALSE, error=FALSE, echo=TRUE----
#> csv_path <- "data/csv/"
#> scen <- read_NSdata(csv_path,"nutrients.csv","monitoring.csv", "forestFr.csv",
#>                     "precipitation.csv","topology.csv", "lakeProperties.csv",
#>                     "length.csv")
#> nutrient <- scen[[1]]
#> catch    <- scen[[2]]


## ----shreve-function, echo=TRUE, eval=FALSE-----------------------------------
#> shreve_order <- shreve("topology.csv")`


## ----read_geometry-function, echo=TRUE, eval=FALSE----------------------------
#> geometry <- read_geometry(file = "data/shapes/Wisla.shp")


## ----input_maps-function, echo=TRUE, eval=FALSE-------------------------------
#> input_maps(nutient, catch, geometry, "Wisla", "gr1")


## ----calib-green, echo=TRUE, eval=FALSE---------------------------------------
#> n_iter <- 2000
#> low <- c(10, 0.000, 0.1)
#> upp <- c(50, 0.1, 0.9)
#> years <- c(1990:2018)
#> 
#> calibration <- calib_green(nutrient, catch, n_iter, low, upp, years)


## ----exec-calib-green---------------------------------------------------------
calibration = readRDS("data/wisla_calib.rds")
aux <- calibration[1:4,] %>% 
  select(alpha_P, alpha_L, sd_coeff, NSE, mNSE, rNSE, KGE, PBIAS..) %>%
  rename("PBIAS %" = PBIAS..)
rownames(aux) <- paste0("s", 1:4)
aux


## ----select_params-function, echo=TRUE, eval=FALSE----------------------------
#> best_params <- select_params(calibration, param = "NSE")
#> 
#> alpha_P  <- best_params$alpha_P
#> alpha_L  <- best_params$alpha_L
#> sd_coeff <- best_params$sd_coeff


## ----calib_boxplot-function, echo=TRUE, eval=FALSE----------------------------
#> calib_boxplot(calibration, rate_bs = 5)


## ----boxplot-vistula-river, out.width = "100%", out.height = "35%", fig.cap = "Plot output from the calib\\_boxplot() function for the Vistula river basin (TN scenario). The top two boxplot rows compare the distribution of the best parameters according to eight GoF for six other GoF metrics. The three figures below show the distribution of parameter values for the top 5\\% of parameter sets according to 8 GoF metrics. The best value is shown as a red dot in each box.", fig.alt="Plot output from the calib\\_boxplot() function for the Vistula river basin (TN scenario). The top two boxplot rows compare the distribution of the best parameters according to eight GoF for six other GoF metrics. The three figures below show the distribution of parameter values for the top 5\\% of parameter sets according to 8 GoF metrics. The best value is shown as a red dot in each box."----
knitr::include_graphics("figures/fig3.png")


## ----simobs-exec, eval=FALSE, echo=TRUE---------------------------------------
#> year_range <-  c(1994, 1996:2001, 2006:2009, 2012)
#> simobs_annual_plot(nutrient, catch, alpha_P, alpha_L, sd_coeff, year_range,
#>                    name_basin = "Wisla", max_value = 10000)


## ----simobs-annual-plot-vistula-river, out.width = "100%", out.height = "35%", fig.cap = "Result of the simobs\\_annual\\_plot() for the Vistula river basin (TN), with the parameter set selected for highest NSE and limiting the plots to the interval between 0 and 10000", fig.alt="Result of the simobs\\_annual\\_plot() for the Vistula TN scenario, with the parameter set selected for highest NSE and limiting the plots to the interval between 0 and 10000"----
knitr::include_graphics("figures/fig4.png")


## ----scatter-exec, eval=FALSE, echo=TRUE--------------------------------------
#> scatter_plot(calibration, param = "R2")


## ----scatter-plot-vistula-river, out.width = "100%", out.height = "35%", fig.cap = "Scatter plots of model parameters against R2 \\citep{althoff2021goodness} metric generated by the scatter\\_plot() function for the Vistula river basin (TN).", fig.alt="Scatter plots of model parameters against R2 \\citep{althoff2021goodness} metric generated by the scatter\\_plot() function for the Vistula river basin (TN)."----
knitr::include_graphics("figures/fig5.png")


## ----calibdot-exec, eval=FALSE, echo=TRUE-------------------------------------
#> calib_dot(calibration, param = "KGE")


## ----dot-plot-vistula-river, out.width = "100%", out.height = "35%", fig.cap = "Dot plots of parameter pairs for the Kling-Gupta efficiency KGE \\citep{althoff2021goodness} generated by the calib\\_dot() function for the Vistula river basin (TN).", fig.alt="Dot plots of parameter pairs for the Kling-Gupta efficiency KGE \\citep{althoff2021goodness} generated by the calib\\_dot() function for the Vistula river basin (TN)."----
knitr::include_graphics("figures/fig6.png")


## ----nutr-exec, eval=FALSE, echo=TRUE-----------------------------------------
#> nutrient_load <- green_shares(nutrient, catch, alpha_P, alpha_L, sd_coeff, years)
#> nutrient_tserie(nutrient_load, geometry, "Wisla Basin", "gr3")


## ----total-TN-vistula-river, out.width = "90%", out.height = "35%", fig.cap = "Total nitrogen load at the Vistula river basin outlet from 1990 to 2018. Colors indicate the contribution of different sources (Min = mineral, Man = manure, Atm = atmospheric deposition, Fix = crop fixation, Soil = soil fixation, Sd = scattered dwellings and Ps = point sources).", fig.alt="Total nitrogen load at the Vistula river basin outlet from 1990 to 2018. Colors indicate the contribution of different sources (Min = mineral, Man = manure, Atm = atmospheric deposition, Fix = crop fixation, Soil = soil fixation, Sd = scattered dwellings and Ps = point sources)."----
knitr::include_graphics("figures/fig7.png")


## ----nutr-maps-exec, eval=FALSE, echo=TRUE------------------------------------
#> map_title <- "Output Loads for the Lay Basin"
#> nutrient_maps(nutrient_load, geometry, map_title, "gr1", legend_position = 1)


## ----maps-TN-vistula-river, out.width = "100%", out.height = "35%", fig.cap = "Maps of total nitrogen loads in the Vistula river basin by different sources and in total (the sum of all other maps, bottom right), in logarithm scale.", fig.alt="Maps of total nitrogen loads in the Vistula river basin by different sources and in total (the sum of all other maps, bottom right), in logarithm scale."----
knitr::include_graphics("figures/fig8.png")


## ----sank-exec, eval=FALSE, echo=TRUE-----------------------------------------
#> nut_bal <- region_nut_balance(nutrient, catch, alpha_P, alpha_L, sd_coeff,
#>                               years)
#> sank <- N4_sankey(nut_bal)


## ----sankey-vistula-river, out.width = "100%", out.height = "35%", fig.cap = "Sankey plot for the Vistula river basin for TN scenario, average for period 1990-2018. The plot represents nitrogen input sources on the left (Min=mineral, Man=manure, Atm=atmospheric deposition, Fix=crop fixation, Soil=soil fixation, Sd=scattered dwellings and Ps=point sources), and nitrogen sinks (land, river and lake retention) and outlet discharge (load to outlet) on the right. The bars in the middle visualize nitrogen agricultural diffuse sources and loads to the stream network (from diffuse and point emissions).", fig.alt="Sankey plot for the Vistula river basin for TN scenario, average for period 1990-2018. The plot represents nitrogen input sources on the left (Min=mineral, Man=manure, Atm=atmospheric deposition, Fix=crop fixation, Soil=soil fixation, Sd=scattered dwellings and Ps=point sources), and nitrogen sinks (land, river and lake retention) and outlet discharge (load to outlet) on the right. The bars in the middle visualize nitrogen agricultural diffuse sources and loads to the stream network (from diffuse and point emissions)."----
knitr::include_graphics("figures/fig9.png")

