# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit color.Rmd to modify this file

## ----preliminaries, include = FALSE-------------------------------------------
## load package
library("colorspace")
## emulate default behavior of palette.colors() starting from R 4.3.0
palette.colors <- function(...) unname(grDevices::palette.colors(...))


## ----colorcatcont-------------------------------------------------------------
#| echo: FALSE
#| message: FALSE
#| warning: FALSE
#| fig.height: 4
#| fig.width: 8
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'h!'
#| fig.cap: 'Typical usage of color for coding qualitative/categorical information (left) and quantitative/continuous information (right). Left: Scatter plot of weekly gas consumption by outside temperature before and after installing house insulation. Right: Choropleth map of median income in the 16 regions of New Zealand in 2018.'
library("ggplot2")
data("whiteside", package = "MASS")
gg <- ggplot(whiteside, aes(Temp, Gas, color = Insul)) +
    geom_point(size = 2) +
    scale_color_manual(name = "Insulation", values = palette.colors(palette = "R4")[c(2, 4)]) +
    ggtitle("Whiteside's data") + 
    xlab("Outside temperature (Celsius)") + 
    ylab("Gas consumption (1000s cubic feet)") +
    theme(legend.position = "none") +
    theme_minimal()

library("tmap")
data("nz", package = "spData")
myfun <- function(x) {
  y <- format(round(x), big.mark = ",")
  z <- grepl("0,000", y, fixed = TRUE) | grepl("5,000", y, fixed = TRUE)
  z[range(seq_along(x))] <- TRUE
  y[!z] <- ""
  return(y)
}
tm <- tm_shape(nz) +
  tm_polygons(col = "Median_income",
    palette = "Blues", style = "cont", breaks = seq(20, 35, by = 5/3) * 1000,
    title = "Median income\n(NZD)",
    legend.format = list(fun = myfun)) +
  tm_layout(frame = FALSE)

library("grid")
grid.newpage()
pushViewport(viewport(x=0, width=.6, just = "left"))
print(gg, newpage=FALSE)
popViewport()
print(tm, vp=viewport(x=1, width=.3, just = "right"))


## ----oldPalettes, fig.width=6, fig.height=1.3---------------------------------
#| echo: FALSE
#| out.width: '100%'
#| fig.align: 'center'
#| fig.keep: 'last'
#| fig.pos: 'ht!'
#| fig.cap: 'Old base R palettes.  At top left is the old default palette (prior to version 4.0.0), consisting largely of highly saturated primary colors or combinations thereof.  Below that is the rainbow palette of different highly saturated hues.  The middle column shows the old sequential palettes, with heat colors again being highly saturated.  The last column shows an old diverging palette plus two palettes motivated by shadings of geographic maps.'
source("paletteGrid.R")
paletteGrids(list("palette()"=palette.colors(palette = "R3"),
                  "heat.colors(8)"=heat.colors(8), 
                  "terrain.colors(8)"=terrain.colors(8),
                  "rainbow(8)"=rainbow(8),
                  "gray.colors(8)"=gray.colors(8),
                  "topo.colors(8)"=topo.colors(8),
                  NULL, 
                  NULL,
                  "cm.colors(8)"=cm.colors(8)), 
             qual=c(TRUE, FALSE, FALSE, 
                    TRUE, FALSE, FALSE, 
                    FALSE, FALSE, FALSE))


## ----echo=2-------------------------------------------------------------------
palette("R3")
palette()
palette("R4")

## ----R3-----------------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
palette("R3")
paletteGrids(list(' '=palette()), qual=TRUE)
palette("R4")


## -----------------------------------------------------------------------------
palette()


## ----R4-----------------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=palette()), qual=TRUE)


## -----------------------------------------------------------------------------
palette.colors()

## ----Okabe-Ito----------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=palette.colors()), qual=TRUE)


## -----------------------------------------------------------------------------
palette.colors(4)


## ----short--------------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=palette.colors(4)), qual=TRUE)


## -----------------------------------------------------------------------------
palette.colors(10, recycle = TRUE)


## ----recycle------------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=palette.colors(10, recycle=TRUE)), qual=TRUE)


## -----------------------------------------------------------------------------
palette.colors(4, palette = "R4")


## -----------------------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=palette.colors(4, palette="R4")), qual=TRUE)


## -----------------------------------------------------------------------------
hcl.colors(8, palette = "Blues 3")

## ----Blues3-------------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=hcl.colors(8, palette = "Blues 3")), qual=FALSE)


## ----blues3hcl, fig.cap = ifelse(knitr::is_html_output(), 'Hue, chroma, and luminance paths for the `"Blues 3"` palette. This plot is created by the `colorspace::specplot()` function.  We can see that hue is held constant in this palette, while luminance increases monotonically and chroma peaks towards the middle of the palette.', 'Hue, chroma, and luminance paths for the \\code{"Blues 3"} palette. This plot is created by the \\code{colorspace::specplot()} function.  We can see that hue is held constant in this palette, while luminance increases monotonically and chroma peaks towards the middle of the palette.')----
#| echo: FALSE
#| fig.width: 5
#| fig.height: 4.5
#| out.width: '49%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
library("colorspace")
specplot(hcl.colors(8, "Blues 3"))


## -----------------------------------------------------------------------------
hcl.colors(5, palette = "YlGnBu")

## ----YlGnBu-------------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=hcl.colors(5, palette = "YlGnBu")), qual=FALSE)


## -----------------------------------------------------------------------------
hcl.colors(9, palette = "Purple-Green")

## ----PurpleGreen--------------------------------------------------------------
#| echo: FALSE
#| fig.width: 6
#| fig.height: .44
#| out.width: '100%'
paletteGrids(list(' '=hcl.colors(9, palette = "Purple-Green")), qual=FALSE)


## ----tsplot, fig.cap = ifelse(knitr::is_html_output(), 'Time series line plot of `EuStockMarkets`. Rows: Old `"R3"` default palette (top), new `"R4"` default palette (middle), `"OkabeIto"` palette (bottom), designed to be robust under color vision deficiencies. Columns: Normal vision (left) and emulated deuteranope vision (right). A color legend is used in the first row and direct labels in the other rows.', 'Time series line plot of \\code{EuStockMarkets}. Rows: Old \\code{"R3"} default palette (top), new \\code{"R4"} default palette (middle), \\code{"OkabeIto"} palette (bottom), designed to be robust under color vision deficiencies. Columns: Normal vision (left) and emulated deuteranope vision (right). A color legend is used in the first row and direct labels in the other rows.')----
#| echo: FALSE
#| fig.height: 7.9
#| fig.width: 10
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'h!'
tsplot <- function(palette = "R3", deutan = FALSE, legend = TRUE, ...) {
  ## color palette
  palette <- match.arg(palette, c("R3", "R4", "Okabe-Ito"))
  p <- switch(palette,
    "R3" = palette.colors(8, "R3")[c(2, 3, 4, 7)],
    "R4" = palette.colors(8, "R4")[c(2, 3, 4, 7)],
    "Okabe-Ito" = palette.colors(8, "Okabe-Ito")[c(7, 4, 6, 5)]
  )
  
  ## emulate deuteranope vision?
  if(deutan) p <- colorspace::deutan(p) 
  
  ## time series plot
  eu <- window(EuStockMarkets, end = 1998)
  plot(eu, log = "y", ylab = "EU stock prices", plot.type = "single", col = p, xlim = c(1991.6, 1998.4), lwd = 1.5, ...)
  text(1991.3, 5750, palette, pos = 4, cex = 1.3)

  ## legend or direct labeling
  if(legend) {
    legend(1991.3, 5750, colnames(eu), col = p, lty = 1, lwd = 3, bty = "n")
  } else {
    text(1998, tail(eu, 1), colnames(eu), pos = 4, col = p, xpd = TRUE)
  }
  
  invisible(p)
}

par(mfrow = c(3, 2), mar = c(4.2, 4, 2, 1))
tsplot(palette = "R3", deutan = FALSE, legend = TRUE, main = "Normal")
tsplot(palette = "R3", deutan = TRUE, legend = TRUE, main = "Deuteranope")
par(mar = c(4.2, 4, 0.5, 1))
tsplot(palette = "R4", deutan = FALSE, legend = FALSE)
tsplot(palette = "R4", deutan = TRUE, legend = FALSE)
tsplot(palette = "Okabe-Ito", deutan = FALSE, legend = FALSE)
tsplot(palette = "Okabe-Ito", deutan = TRUE, legend = FALSE)


## ----dorian, fig.cap = ifelse(knitr::is_html_output(), 'Probability of wind speeds $>$ 39 mph (63 km h$^{-1}$) during hurricane Dorian in 2019. On the left is the the original image (top row) and two reproductions using the `"Reds"` (middle) and `"YlGnBu"` (bottom) sequential palettes. On the right are emulations of how the images on the left might appear to a colorblind viewer.', 'Probability of wind speeds $>$ 39\\,mph (63\\,km\\,h$^{-1}$) during hurricane Dorian in 2019. On the left is the the original image (top row) and two reproductions using the \\code{"Reds"} (middle) and \\code{"YlGnBu"} (bottom) multi-hue sequential palettes. On the right are emulations of how the images on the left might appear to a colorblind viewer.')----
#| echo: FALSE
#| out.width: '100%'
#| fig.width: 6
#| fig.height: 2.5
#| fig.align: 'center'
#| fig.pos: 't!'
#| fig.show: 'hold'
library("cowplot")
ggdraw() + 
  draw_image("images/dorian-orig.png", width = 0.5) + 
  draw_image("images/dorian-orig-deutan.png", width = 0.5, x = 0.5)

ggdraw() + 
  draw_image("images/dorian-reds.png", width = 0.5) +
  draw_image("images/dorian-reds-deutan.png", width = 0.5, x = 0.5)

ggdraw() + 
  draw_image("images/dorian-ylgnbu.png", width = 0.5) + 
  draw_image("images/dorian-ylgnbu-deutan.png", width = 0.5, x = 0.5)


## ----ylgnbu-viridis, fig.cap = ifelse(knitr::is_html_output(), 'Hue, chroma, and luminance paths for the `"YlGnBu"` (left) and `"Viridis"` (right) palettes. These plots are created by the `colorspace::specplot()` function. For `"YlGnBu"` we can see that hue changes from blue to yellow, luminance increases monotonically, and chroma has a small peak in the blue range and then decreases with luminance. `"Viridis"`, on the other hand, has almost the same trajectory for both hue and luminance, but chroma increases for the light colors.', 'Hue, chroma, and luminance paths for the \\code{"YlGnBu"} (left) and \\code{"Viridis"} (right) palettes. These plots are created by the \\code{colorspace::specplot()} function. For \\code{"YlGnBu"} we can see that hue changes from blue to yellow, luminance increases monotonically, and chroma has a small peak in the blue range and then decreases with luminance. \\code{"Viridis"}, on the other hand, has almost the same trajectory for both hue and luminance, but chroma increases for the light colors.')----
#| echo: FALSE
#| fig.width: 5
#| fig.height: 4.5
#| out.width: '49%'
#| fig.align: 'center'
#| fig.show: 'hold'
#| fig.pos: 't!'
specplot(hcl.colors(10, "YlGnBu"))
text(-0.05, 0.83, "YlGnBu", pos = 4, xpd = TRUE)
specplot(hcl.colors(10, "Viridis"))
text(-0.05, 0.83, "Viridis", pos = 4, xpd = TRUE)


## ----newPalettes, fig.cap = ifelse(knitr::is_html_output(), 'New qualitative palettes in base R available from the `palette.colors()` function.  The label above each swatch shows the argument to provide to `palette.colors()` to produce the set of colors.  The palette at top-left is the new default that is also produced by `palette()`.  The `"Okabe-Ito"` palette is the default that is produced by `palette.colors()` (with no arguments).', 'New qualitative palettes in base R available from the \\code{palette.colors()} function.  The label above each swatch shows the argument to provide to \\code{palette.colors()} to produce the set of colors.  The palette at top-left is the new default that is also produced by \\code{palette()}.  The \\code{"Okabe-Ito"} palette is the default that is produced by \\code{palette.colors()} (with no arguments).')----
#| echo: FALSE
#| fig.width: 6
#| fig.height: 4
#| fig.keep: 'last'
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
paletteGrids(list('"R4"'=palette.colors(palette = "R4"),
                  '"Okabe-Ito"'=palette.colors(palette = "Okabe-Ito"),
                  blank=NULL,
                  blank=NULL,
                  blank=NULL,
                  blank=NULL,
                  '"ggplot2"'=palette.colors(palette = "ggplot2"),
                  '"Tableau 10"'=palette.colors(palette = "Tableau 10"),
                  '"Classic Tableau"'=palette.colors(palette = "Classic Tableau"),
                  blank=NULL,
                  blank=NULL,
                  blank=NULL,
                  '"Set 1"'=palette.colors(palette = "Set 1"),
                  '"Dark 2"'=palette.colors(palette = "Dark 2"),
                  '"Accent"'=palette.colors(palette = "Accent"),
                  '"Set 2"'=palette.colors(palette = "Set 2"),
                  '"Pastel 1"'=palette.colors(palette = "Pastel 1"),
                  '"Paired"'=palette.colors(palette = "Paired"),
                  '"Set 3"'=palette.colors(palette = "Set 3"),
                  '"Pastel 2"'=palette.colors(palette = "Pastel 2"),
                  blank=NULL,
                  blank=NULL,
                  blank=NULL,
                  blank=NULL,
                  '"Alphabet"'=palette.colors(palette = "Alphabet"),
                  '"Polychrome 36"'=palette.colors(palette = "Polychrome 36")),
              qual=TRUE)
downViewport("top")
drawBorder(1, name = "bg1")
drawBorder(3, name = "bg2")
drawBorder(5:7, name = "bg3")
drawBorder(9, name = "bg4",
           y2=unit(1, "npc") - 4*cellSize - gap)
scene <- grid.grab()
scene <- reorderGrob(scene, c("bg1", "bg2", "bg3", "bg4"))
grid.newpage()
grid.draw(scene)


## -----------------------------------------------------------------------------
palette.pals()


## -----------------------------------------------------------------------------
palette("Okabe-Ito")


## ----qualPalettes, fig.cap = ifelse(knitr::is_html_output(), 'The qualitative palettes that are available with the `hcl.colors()` function.', 'The qualitative palettes that are available with the \\code{hcl.colors()} function.')----
#| echo: FALSE
#| fig.width: 6
#| fig.height: 2
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
pals <- hcl.pals("qualitative")
args <- lapply(pals,
               function(x) {
                    hcl.colors(8, x)
               })
names(args) <- paste0('"', pals, '"')
args <- c(args[c('"Pastel 1"', '"Dark 2"', '"Set 2"')],
          list(NULL), args[c('"Dark 3"', '"Set 3"')],
          list(NULL, NULL, NULL),
          args[c('"Warm"', '"Cold"', '"Harmonic"')],
          list(NULL, NULL), args['"Dynamic"'])
paletteGrids(args, qual=TRUE)


## ----singleSeqPalettes, fig.cap = ifelse(knitr::is_html_output(), 'The single-hue sequential palettes that are available with the `hcl.colors()` function.', 'The single-hue sequential palettes that are available with the \\code{hcl.colors()} function.')----
#| echo: FALSE
#| fig.width: 6
#| fig.height: 1.7
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
single <- rownames(hcl_palettes("sequential (single-hue)"))
pals <- hcl.pals("sequential")
singlePals <- pals[pals %in% single]
args <- lapply(singlePals,
               function(x) {
                    hcl.colors(8, x)
               })
names(args) <- paste0('"', singlePals, '"')
args <- c(args[c('"Grays"', '"Blues 3"', '"Purples 3"',
                 '"Light Grays"', '"Blues 2"', '"Purples 2"',
                 '"Reds 3"', '"Greens 3"')], list(NULL),
          args[c('"Reds 2"', '"Greens 2"', '"Oslo"')])
paletteGrids(args, qual=FALSE)


## ----multiSeqPalettes, fig.cap = ifelse(knitr::is_html_output(), 'Some of the multi-hue sequential palettes that are available with the `hcl.colors()` function.', 'Some of the multi-hue sequential palettes that are available with the \\code{hcl.colors()} function.')----
#| echo: FALSE
#| fig.width: 6
#| fig.height: 6.2
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
single <- rownames(hcl_palettes("sequential (single-hue)"))
pals <- hcl.pals("sequential")
multiPals <- pals[! pals %in% single]
args <- lapply(multiPals,
               function(x) {
                    hcl.colors(8, x)
               })
names(args) <- paste0('"', multiPals, '"')
args <- c(args[c('"Red-Blue"', '"Purple-Orange"', '"Green-Yellow"')],
          args[c('"Red-Purple"', '"Purple-Blue"', '"Terrain"')],
          args[c('"Red-Yellow"', '"Purple-Yellow"', '"Terrain 2"')],
          args[c('"Heat"', '"Blue-Yellow"')], list(NULL),
          args[c('"Heat 2"')], list(NULL, NULL),
          list(NULL, NULL, NULL),
          args[c('"Viridis"', '"Inferno"', '"Mako"')],
          args[c('"Plasma"', '"Rocket"')], list(NULL),
          list(NULL, NULL, NULL),
          args[c('"Mint"', '"Peach"', '"Purp"')],
          args[c('"Dark Mint"', '"OrYel"', '"PurpOr"')],
          args[c('"Teal"', '"PinkYl"', '"Magenta"')],
          args[c('"TealGrn"', '"RedOr"', '"Sunset"')],
          args[c('"BluGrn"', '"Burg"', '"SunsetDark"')],
          args[c('"Emrld"', '"BurgYl"', '"ag_Sunset"')],
          args[c('"BluYl"', '"BrwnYl"')], list(NULL),
          args[c('"ag_GrnYl"')], list(NULL, NULL))
paletteGrids(args, qual=FALSE)


## ----multiSeqPalettes2, fig.cap = ifelse(knitr::is_html_output(), 'Some of the multi-hue sequential palettes that are available with the `hcl.colors()` function.', 'Some of the multi-hue sequential palettes that are available with the \\code{hcl.colors()} function.')----
#| echo: FALSE
#| fig.width: 6
#| fig.height: 3.6
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
single <- rownames(hcl_palettes("sequential (single-hue)"))
pals <- hcl.pals("sequential")
multiPals <- pals[! pals %in% single]
args <- lapply(multiPals,
               function(x) {
                    hcl.colors(8, x)
               })
names(args) <- paste0('"', multiPals, '"')
args <- c(args[c('"Reds"', '"Greens"', '"Blues"')],
          args[c('"OrRd"', '"BuGn"', '"PuBu"')],
          args[c('"Oranges"', '"YlGn"', '"BuPu"')],
          args[c('"YlOrRd"', '"YlGnBu"', '"Purples"')],
          args[c('"YlOrBr"', '"GnBu"', '"RdPu"')],
          list(NULL), args[c('"PuBuGn"', '"PuRd"')],
          list(NULL, NULL, NULL),
          args[c('"Lajolla"', '"Hawaii"')], list(NULL), 
          args[c('"Turku"', '"Batlow"')], list(NULL))
paletteGrids(args, qual=FALSE)


## ----purplegreen-fall, fig.cap = ifelse(knitr::is_html_output(), 'Hue, chroma, and luminance paths for the `"Purple-Green"` (left) and `"Fall"` (right) palettes. The plots are created by the `colorspace::specplot()` function. We can see that the `"Purple-Green"` palette is "balanced" with luminance and chroma varying symmetrically about the central neutral color for both hues. In contrast, the `"Fall"` palette is "unbalanced" with the left arm of the palette having somewhat darker colors with far less chroma than the right arm. Hue changes gradually from green through yellow to red, yielding a warmer palette compared to `"Purple-Green"`.', 'Hue, chroma, and luminance paths for the \\code{"Purple-Green"} (left) and \\code{"Fall"} (right) palettes. The plots are created by the \\code{colorspace::specplot()} function. We can see that the \\code{"Purple-Green"} palette is "balanced" with luminance and chroma varying symmetrically about the central neutral color for both hues. In contrast, the \\code{"Fall"} palette is "unbalanced" with the left arm of the palette having somewhat darker colors with far less chroma than the right arm. Hue changes gradually from green through yellow to red, yielding a warmer palette compared to \\code{"Purple-Green"}.')----
#| echo: FALSE
#| fig.width: 5
#| fig.height: 4.5
#| out.width: '49%'
#| fig.align: 'center'
#| fig.show: 'hold'
#| fig.pos: 'ht!'
library("colorspace")
specplot(hcl.colors(9, "Purple-Green"))
text(-0.05, 0.83, "Purple-Green", pos = 4, xpd = TRUE)
specplot(hcl.colors(9, "Fall"))
text(-0.05, 0.83, "Fall", pos = 4, xpd = TRUE)


## ----diverPalettes, fig.cap = ifelse(knitr::is_html_output(), 'The balanced diverging palettes that are available with the `hcl.colors()` function.', 'The balanced diverging palettes that are available with the \\code{hcl.colors()} function.')----
#| echo: FALSE
#| fig.width: 6
#| fig.height: 3
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
pals <- hcl.pals("diverging")
args <- lapply(pals,
               function(x) {
                    hcl.colors(9, x)
               })
names(args) <- paste0('"', pals, '"')
args <- c(args[c('"Green-Orange"', '"Blue-Yellow 3"', '"Cyan-Magenta"',
                 '"Green-Brown"', '"Blue-Yellow 2"', '"Tropic"')],
          list(NULL, NULL, NULL),
          args[c('"Blue-Red"', '"Blue-Red 3"', '"Red-Green"',
                 '"Blue-Red 2"', '"Purple-Brown"', '"Purple-Green"')], 
          list(NULL, NULL, NULL),
          args[c('"Broc"', '"Cork"', '"Vik"', 
                 '"Berlin"', '"Lisbon"', '"Tofino"')])
paletteGrids(args, qual=FALSE)


## ----diverxPalettes, fig.cap = ifelse(knitr::is_html_output(), 'The flexible diverging palettes that are available with the `hcl.colors()` function.', 'The flexible diverging palettes that are available with the \\code{hcl.colors()} function.')----
#| echo: FALSE
#| fig.width: 6
#| fig.height: 3.8
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
pals <- hcl.pals("divergingx")
args <- lapply(pals,
               function(x) {
                    hcl.colors(9, x)
               })
names(args) <- paste0('"', pals, '"')
args <- c(args[c('"Temps"', '"ArmyRose"', '"Fall"')],
          args[c('"TealRose"', '"Earth"')], list(NULL),
          args[c('"Geyser"')], list(NULL, NULL),
          list(NULL, NULL, NULL),
          args[c('"RdGy"', '"Spectral"', '"PiYG"')],
          args[c('"RdBu"', '"RdYlBu"', '"PRGn"')],
          args[c('"PuOr"', '"RdYlGn"', '""')],
          args[c('"BrBG"', '""', '""')],
          list(NULL, NULL, NULL),
          args[c('"Zissou 1"', '"Cividis"', '"Roma"')])
paletteGrids(args, qual=FALSE)


## ----graphics, fig.cap = ifelse(knitr::is_html_output(), 'Examples of the new default color palettes that are used in the base graphics functions `image()`, `boxplot()`, and `hist()`.', 'Examples of the new default color palettes that are used in the base graphics functions \\code{image()}, \\code{boxplot()}, and \\code{hist()}.')----
#| echo: -1
#| fig.height: 4
#| fig.width: 14
#| out.width: '100%'
#| fig.align: 'center'
#| fig.pos: 'ht!'
par(mfrow = c(1, 3))
image(volcano)
boxplot(weight ~ feed, data = chickwts)
hist(chickwts$weight)


## ----palette-overview, include=FALSE------------------------------------------
tab <- data.frame(
  Type = c("Information", "Function", "List", "Robust"),
  Qualitative = c("Categorical", "`palette.colors()`, `hcl.colors()`", "`palette.pals()`, `hcl.pals(\"qualitative\")`", "`\"Okabe-Ito\"`"),
  Sequential = c("Ordered or numeric (high $\\rightarrow$ low)", "`hcl.colors()`", "`hcl.pals(\"sequential\")`", "Most? `\"Viridis\"`, `\"YlnGnBu\"`"),
  Diverging = c("Numeric with central reference (high $\\leftarrow$ neutral $\\rightarrow$ low)", "`hcl.colors()`", "`hcl.pals(\"diverging\")`, `hcl.pals(\"divergingx\")`", "`\"Purple-Green\"`, `\"Blue-Red 3\"`")
)
knitr::kable(tab, caption = "Palette overview.")

