# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit paper.Rmd to modify this file

params <-
list(ref_setup_fn = "ref-setup.R")

## ----setup, cache = FALSE, include = FALSE------------------------------------
library(glue)
library(ggwordcloud)
library(tidyverse)
library(patchwork)
library(tidygraph)
library(ggraph)
theme_set(
  theme(
    panel.background = element_rect(fill = NA),
    panel.grid = element_line(color = "lightgray"),
    axis.text = element_text(color = "black"),
    axis.line = element_line(color = "black", size = 0.7),
    axis.ticks.length = unit(1.4, "mm"),
    axis.ticks = element_line(color = "black", size = 0.7),
    axis.title = element_text(color = "black", face = "bold"),
    strip.background = element_rect(color = "black",
                                    fill = "white"),
    strip.text = element_text(color = "black",
                              margin = margin(5, 5, 5, 5)),
    plot.title.position = "plot",
    plot.title = element_text(color = "black", hjust = 0)
  )
)
knitr::opts_chunk$set(echo = FALSE, 
                      cache = TRUE,
                      cache.path = "cache/",
                      fig.align = 'center', 
                      fig.pos = 'htbp', 
                      fig.path = "figures/",
                      fig.width = 6,
                      fig.height = 6.5,
                      message = FALSE,
                      warning = FALSE)
source(params$ref_setup_fn)


## ----data, include = FALSE----------------------------------------------------
ctv_pkg_data <- readRDS("output/ctv_pkg_data.rds")
ctv_summary_table <- readRDS("output/ctv_summary_table.rds")
doe_bigram_all_with_download_data <- readRDS("output/doe_bigram_all_with_download_data.rds")
doe_pkg_network <- readRDS("output/doe_pkg_network.rds")
ctv_gini_yearly <- readRDS("output/ctv_gini_yearly.rds")
ctv_lorenz_yearly <- readRDS("output/ctv_lorenz_yearly.rds")
ctv_rank_yearly <- readRDS("output/ctv_rank_yearly.rds")
access_date_pkg_downloads <- readRDS("output/access_date_pkg_downloads.rds")

doe_npkgs <- ctv_summary_table %>% 
  filter(name=="ExperimentalDesign") %>% 
  pull(n)

doe_npkgs_2021 <- ctv_gini_yearly %>% 
  filter(year==2021, name=="ExperimentalDesign") %>% 
  pull(n)

doe_ginis <- ctv_gini_yearly %>% 
  filter(name == "ExperimentalDesign") %>% 
  pull(gini)


lorenz_value <- function(p) {
  ctv_lorenz_yearly %>% 
    filter(name == "ExperimentalDesign",
           year == 2021) %>% 
    unpack(lorenz_data) %>% 
    mutate(pdist = abs(p - .env$p)) %>% 
    filter(pdist == min(pdist)) %>% 
    pull(L) %>% 
    magrittr::multiply_by(100) %>% 
    round()
}


## ----plot-lorenz, fig.height = 4, fig.width = 4, fig.cap = "Lorenz curve of the total download count for DoE packages in 2021. The red line corresponds to the line of perfect equality. The yellow region shows the area under the Lorenz curve and the red region shows the area of the gap in equality."----
ctv_lorenz_yearly %>% 
  filter(name == "ExperimentalDesign",
         year == 2021) %>% 
  ggplot(aes(lorenz_data$p * 100, lorenz_data$L * 100)) +
  geom_abline(color = "red") +
  geom_ribbon(aes(ymin = 0, ymax = lorenz_data$L * 100),
                fill = "#FFC107", alpha = 0.5) +
  geom_ribbon(aes(ymin = lorenz_data$L * 100, ymax = lorenz_data$p * 100),
                 fill = "#D81B60", alpha = 0.5) +
  geom_line() + 
  geom_point() +
  annotate("text", x = 75, y = 80, 
           label = "Line of perfect equality",
            angle = 45) +
  labs(y = "Cumulative share of downloads (%)",
       x = "Percentage of DoE packages") +
  theme(plot.margin = margin(r = 20, t = 20)) +
  scale_x_continuous(breaks = seq(0, 100, by = 10)) +
  scale_y_continuous(breaks = seq(0, 100, by = 10))


## ----download-share, fig.width = 5.5, fig.height = 4, fig.cap = "Distribution of number of downloads for DoE packages by year. Packages were removed in any year if they were released in that year or later so that each download count was for the full year. The label at the bottom of the plot shows the Gini index for downloads and the number of packages with a full download count in the corresponding year. In the last six years, the Gini index has consistently exceeded 60\\%, indicating that most downloads are due to a relatively small number of packages. "----
ctv_rank_yearly %>% 
    filter(name == "ExperimentalDesign") %>% 
    mutate(year = as.factor(year)) %>% 
    ggplot(aes(x = year, y = total)) + 
    geom_violin() +
    geom_boxplot(width = 0.1) + 
    labs(x = "Year", y = "Number of downloads") + 
    scale_y_log10(label = scales::comma, expand = c(0.1, 0)) +
    geom_label(data = ctv_gini_yearly %>% 
                        filter(name == "ExperimentalDesign") %>% 
                        mutate(year = as.factor(year)), 
               size = 3,
               aes(y = 900, 
                   label = paste0(scales::percent(gini, 0.1),
                                   "\nn=", n)))


## ----fig-gini-all-ctvs, fig.height = 4, fig.width = 4, fig.cap = "The points show the Gini index of the download counts by year for the ExperimentalDesign task view with the color showing the number of packages. The gray lines show the line plots of the Gini index across years for all other CRAN task views. See Figure S1 in the Supplementary Material for the line graph of the Gini index across years for each CRAN task view."----
ctv_gini_yearly %>% 
  arrange(name, year) %>% 
  mutate(name = fct_reorder(name, gini, last),
         year = factor(year),
         gini = 100 * gini) %>%  
  ggplot(aes(year, gini, group = name)) + 
  geom_line(color = "grey") +
  geom_line(data = ~filter(.x, name=="ExperimentalDesign")) + 
  geom_point(data = ~filter(.x, name=="ExperimentalDesign"),
             aes(color = n)) +
  labs(x = "Year", y = "Gini index (%)", color = "# of packages",
       title = "ExperimentalDesign CRAN task view") +
  guides(color = guide_colorbar(direction = "horizontal")) +
  theme(legend.position = "bottom") +
  scale_colour_distiller(palette = "YlOrRd", direction = 1) 


## ----rank-over-time, fig.width = 5.5, fig.height = 4.5, fig.cap = "The plot shows the rank of the top 10 packages downloaded by year. Packages that did not appear in the top 10 for at least two periods were omitted from the plot. Most packages are consistently in the top 10 for the period shown."----
nrank <- 10
pkgs_repeat_toprank <- ctv_rank_yearly %>% 
  filter(name=="ExperimentalDesign") %>% 
  filter(rank <= nrank) %>% 
  count(package) %>% 
  filter(n > 1) %>% 
  pull(package)

ctv_rank_yearly %>% 
  filter(name=="ExperimentalDesign",
         package %in% pkgs_repeat_toprank) %>% 
  mutate(year = as.factor(year)) %>% 
  ggplot(aes(year, rank, color = package)) +
  geom_point() + 
  geom_line(aes(group = package)) + 
  scale_y_reverse(breaks = 1:nrank) +
  geom_text(aes(label = package),
            data = ~filter(.x, year == 2021),
            hjust = 0,
            nudge_x = 0.1) +
  guides(color = "none") + 
  scale_x_discrete(expand = expansion(c(0.05, 0.25))) +
  labs(color = "Package", x = "Year", y = "Download rank") +
  scale_color_manual(values = c("#E69F00", "#56B4E9", "#009E73", 
                                  "#F0E442", "#0072B2", "#D55E00", 
                                  "#CC79A7", "#000000", "#888888",
                                  "#88CCEE", "#CC6677", "seagreen4", 
                                  "violetred4"))


## ----release-date-vs-download, fig.height = 5, fig.cap = "The above figure shows the total download (in log scale) of a package in the corresponding year against the first release date of the package. The blue line corresponds to the least-squares fit of the simple linear regression model. The label in the upper right-hand corner shows the sample correlation coefficient between the first release date and log (with base 10) of the total download count. The high leverage point on the far left belongs to `conf.design`, authored by one of the earlier contributors to R."----
ctv_rank_yearly %>% 
  filter(name == "ExperimentalDesign") %>% 
  ggplot(aes(first, total/1000)) +
  geom_point(aes(color = nupdates)) + 
  geom_label(data = ~ .x %>% 
              group_by(year) %>% 
              summarise(R = cor(as.numeric(first), log10(total/1000)) %>% 
                          scales::comma(0.01) %>% 
                          paste0("r = ", .),
                        y = quantile(total/1000, 0.99)),
            aes(label = R, y = y, x = as.Date("2014-11-01")),
            size = 3) +
  facet_wrap(~year, scale = "free_y") +
  geom_smooth(se = FALSE, 
              method = lm, 
              formula = y ~ x) +
  scale_y_log10() + 
  scale_color_continuous(trans = "log10") + 
  labs(x = "First release date",
       y = "Total download (1000s)",
       color = "# of updates") +
  theme(legend.position = "bottom")


## ----wordcloud-over-time, fig.width = 5.5, fig.height = 5, fig.cap = "The above figure shows the word cloud of bigrams from the title and descriptions of the DoE packages. The size shows how often the bigram appears across the DoE packages and the color is relative to the total download count in 2021 for the packages that contain the bigram."----
doe_bigram_all_with_download_data %>%
  filter(perc >= 1, n > 1, year == 2021) %>%
  ggplot(aes(
    label = word,
    color = perc,
    size = n
  )) +
  geom_text_wordcloud(shape = "square",
                      show.legend = TRUE) +
  guides(size = "none") +
  theme(legend.position = "bottom",
        text = element_text(size = 18)) +
  guides(color = guide_colorbar(title.position = "top")) +
  scale_size_area(max_size = 5) +
  theme(legend.text = element_text(size = 10),
        legend.title = element_text(size = 12)) +
  labs(color = "Total downloads (%)")


## ----ctv-summ-plot, fig.width = 5.5, fig.height = 6, fig.cap = "The above figure is a scatterplot of intra-connectivity (the percentage of packages that depends, suggests or imports at least one other package within the same task view) and the average number of contributors for each CRAN task view. Low intra-connectivity suggests that development within the topic mostly occurs in silos, while high  intra-connectivity suggests that there are more interactions within the topic. The color shows the number of packages, the size of the point corresponds to the total number of contributors, and the text labels show the CRAN task view names.  The label of ExperimentalDesign task view is colored in red. The task views in the bottom-left corner are topics that are more indicative of contributors working in silos. The actual numerical values are listed in Table S1 in the Supplementary Material."----
ctv_summary_table %>% 
  ggplot(aes(avg_contributors, intra_perc)) +
  geom_point(aes(size = ncontributors,
                 color = n)) +
  ggnewscale::new_scale_color() + 
  ggrepel::geom_text_repel(aes(label = name,
                               color = name=="ExperimentalDesign"),
                           force = 150,
                           max.iter = 20000) +
  guides(color = "none") + 
  scale_color_manual(values = c("black", "#CC3311")) + 
  labs(x = "Average number of contributors",
       y = "Intra-connectivity (%)",
       size = "Total number of contributors",
       color_new = "Total number of packages") +
  theme(legend.position = "bottom",
        legend.box = "vertical",
        legend.box.just = "left")


## ----plot-doe-network, fig.width = 6, fig.height = 6, fig.cap  = "Package connections (depends, suggests and imports) within DoE packages. The direction of the arrow shows the connection of packags where the package on the tail of the arrow is a dependency, suggestion or import for the package on the head of the arrow.  DoE packages that do not depend, suggest or import another DoE package are not shown."----
doe_pkg_network %>%
  ggraph('fr') +
  geom_edge_link(aes(color = Type),
                 arrow = arrow(length = unit(3, 'mm')),
                 end_cap = circle(3, 'mm')) +
  geom_node_point(size = 4) +
  geom_node_text(aes(label = name), repel = TRUE, size = 3.5) +
  theme_graph(base_family = "Helvetica") +
  labs(color = "") +
  theme(legend.position = "bottom")

