# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit reslr.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
library(knitr)
knitr::opts_chunk$set(
  fig.align = "center",
  fig.retina=5,
  echo = FALSE,
  warning = FALSE,
  message = FALSE,
  cache = TRUE,
  cache.extra = rand_seed
)
library("ggplot2") # for visualisations
library("tidyverse")

#devtools::install_github("maeveupton/reslr",force = TRUE,INSTALL_opts = '--no-lock')
library(reslr)


## ----dag,out.width="50%",eval = TRUE,echo=FALSE,fig.align = 'center',fig.cap = "A visual representation of the Bayesian hierarchical model structure used for each statistical model in the reslr package."----
knitr::include_graphics("figures/hierarchical_model_def.png")


## ----data, echo= TRUE,eval = TRUE---------------------------------------------
CedarIslandNC <- reslr::NAACproxydata %>% 
  dplyr::filter(Site == "Cedar Island")

glimpse(CedarIslandNC)


## ----loaddata, echo = TRUE,eval = TRUE,message=FALSE,results='hide'-----------
CedarIslandNC_input <- reslr_load(data = CedarIslandNC)


## ----print, echo= TRUE,eval = TRUE--------------------------------------------
print(CedarIslandNC_input)


## ----plotdata, echo= TRUE,fig.align = 'center',fig.width=5,fig.height=3,fig.cap="A plot of the raw data for our example site Cedar Island North Carolina. The x-axis is time in years in the Common Era (CE) and the y-axis is relative sea level in metres. The grey boxes are 1 standard deviation vertical and horizontal (temporal) uncertainty. The black dots are the midpoints of the uncertainty boxes.",eval = TRUE----
plot(CedarIslandNC_input, plot_caption = FALSE)


## ----run, echo= TRUE,eval = TRUE,results='hide',message=FALSE-----------------
res_ni_spline_t <- reslr_mcmc(input_data = CedarIslandNC_input,
                              model_type = "ni_spline_t")


## ----printres, echo = TRUE,eval = TRUE----------------------------------------
print(res_ni_spline_t)


## ----summary, echo= TRUE,eval = TRUE------------------------------------------
summary(res_ni_spline_t)


## ----nisplinemodfit, echo= TRUE,fig.align = 'center',fig.width=5,fig.height=3, fig.cap="The plot of the Noisy Input spline in time model fit for our example site, Cedar Island, North Carolina. The x-axis is time in years in the Common Era (CE) and the y-axis is relative sea level in metres. The grey boxes are 1 standard deviation vertical and horizontal (temporal) uncertainty. The black dots are the midpoints of the uncertainty boxes. The solid purple line represents the posterior model fit with a 95\\% credible interval denoted by shading.",eval = TRUE----
plot(res_ni_spline_t,
     plot_type = "model_fit_plot",
     plot_caption = FALSE)



## ----nisplinemodrate,echo=TRUE, fig.align = 'center',fig.width=5,fig.height=3,fig.cap="The rate of change model fit using Noisy Input spline in time model for our example site Cedar Island, North Carolina. The rate is calculated by taking the first derivative of the total model fit. The x-axis is time in years in the Common Era (CE) and the y-axis is the instantaneous rate of change of sea level in mm per year. The solid purple line represents the posterior model fit with a 95\\% credible interval denoted by shading. There is a black horizontal line which is the zero rate of change for this site.", eval = TRUE----
plot(res_ni_spline_t,
     plot_type = "rate_plot",
     plot_caption = FALSE)


## ----datamulti, echo= TRUE,eval = TRUE----------------------------------------
multi_site <- reslr::NAACproxydata %>% 
  dplyr::filter(Site %in% c("Cedar Island","Nassau",
                            "East River Marsh", "Swan Key",
                            "Placentia",
                            "Pelham Bay","Fox Hill Marsh",
                            "Snipe Key","Big River Marsh"))


## ----loaddatamulti, echo = TRUE,eval = TRUE,message=FALSE,results='hide'------
multi_site_input <- reslr_load(
  data = multi_site,
  include_tide_gauge = TRUE,
  include_linear_rate = TRUE,
  TG_minimum_dist_proxy = TRUE,
  all_TG_1deg = TRUE)


## ----printmulti, echo= TRUE,eval = TRUE---------------------------------------
print(multi_site_input)


## ----plotdatamulti, echo= TRUE,fig.width = 5, fig.height = 5,fig.cap ="A plot of the raw data for our nine example sites along the Atlantic coast of North America. The x-axis is time in years in the Common Era (CE) and the y-axis is relative sea level in metres. The grey boxes are 1 standard deviation vertical and horizontal (temporal) uncertainty. The black dots are the midpoints of the uncertainty boxes.",eval = TRUE----
plot(x = multi_site_input,
     plot_proxy_records = TRUE,
     plot_tide_gauges = FALSE,
     plot_caption = FALSE)


## ----nigammcmc,eval = FALSE,echo=TRUE, results='hide',message=FALSE-----------
#> res_ni_gam_decomp <- reslr_mcmc(
#>   input_data =  multi_site_input,
#>   model_type = "ni_gam_decomp"
#> )


## ----summarymcmcnigam, eval = FALSE,echo=TRUE---------------------------------
#> summary(res_ni_gam_decomp)


## ----summaryprint,eval=FALSE,echo=TRUE----------------------------------------
#> #> No convergence issues detected.
#> #> # A tibble: 4 x 7
#> #>   variable       mean      sd     mad     q5    q95  rhat
#> #>   <chr>         <num>   <num>   <num>  <num>  <num> <num>
#> #> 1 sigma_beta_h 1.82   0.257   0.247   1.45   2.29    1.00
#> #> 2 sigma_beta_r 0.288  0.0547  0.0505  0.213  0.391   1.00
#> #> 3 sigma_beta_l 0.939  0.148   0.145   0.717  1.21    1.00
#> #> 4 sigma_y      0.0155 0.00107 0.00108 0.0138 0.0173  1.00


## ----niplotrate,echo=TRUE,eval = FALSE----------------------------------------
#> plot(res_ni_gam_decomp,
#>      plot_type = "rate_plot",
#>      plot_caption = FALSE)


## ----niplotrateload,out.width = '80%',echo=FALSE,fig.align = 'center', fig.cap = "The rate of change for the total model fit for the Noisy Input generalised additive model for sites along the Atlantic coast of North America. It is calculated by finding the derivative of the total model fit. The solid purple line is the mean rate of change fit and the shading denotes 95\\% credible interval for each site along the Atlantic coast of North America. The x-axis is time in years in the Common Era (CE) and the y-axis is rate of change in mm per year."----
knitr::include_graphics("figures/niplotrate-1.png")


## ----regrateplot,eval = FALSE,echo=TRUE---------------------------------------
#> plot(res_ni_gam_decomp,
#>      plot_type = "regional_rate_plot",
#>      plot_caption = FALSE)


## ----regrateplotload,out.width = '80%',eval = TRUE,echo=FALSE,fig.align = 'center',fig.cap = "The rate of change for the regional component of the Noisy Input generalised additive model for the nine proxy sites and the eleven tide gauges along the Atlantic coast of North America. It is calculated by finding the derivative of the regional component fit. The solid blue line is the mean rate of change fit and the shading denotes 95\\% credible interval. The x-axis is time in years in the Common Era (CE) and the y-axis is rate of change in mm per year."----
knitr::include_graphics("figures/regrateplot-1.png")

