# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit pomdp.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)


## ----echo = TRUE--------------------------------------------------------------
library("pomdp")

Tiger <- POMDP(
  name = "Tiger Problem",
  discount = 0.75,
  states = c("tiger-left" , "tiger-right"),
  actions = c("listen", "open-left", "open-right"),
  observations = c("tiger-left", "tiger-right"),
  start = "uniform",
  
  transition_prob = list(
    "listen" = "identity", 
    "open-left" = "uniform", 
    "open-right" = "uniform"),

  observation_prob = list(
    "listen" = matrix(c(0.85, 0.15, 0.15, 0.85), nrow = 2, byrow = TRUE), 
    "open-left" = "uniform",
    "open-right" = "uniform"),
    
  reward = rbind(
    R_("listen",     NA,            NA,  NA,   -1),
    R_("open-left",  "tiger-left",  NA , NA, -100),
    R_("open-left",  "tiger-right", NA , NA,   10),
    R_("open-right", "tiger-left",  NA , NA,   10),
    R_("open-right", "tiger-right", NA , NA, -100)
  )
)


## ----tiger-transition, echo = TRUE, fig.width = 8, fig.height = 5, out.width = "100%", fig.cap="Transition model of the Tiger problem.", fig.alt="A graph showing the transition model of the Tiger problem."----
g <- transition_graph(Tiger)

library(igraph)
plot(g,
 layout = rbind(c(-1, 0), c(1, 0)), rescale = FALSE,
 edge.curved = curve_multiple_directed(g, .8),
 edge.loop.angle = pi / 2,
 vertex.size = 65
)


## ----echo = TRUE--------------------------------------------------------------
sol <- solve_POMDP(Tiger)
sol


## ----echo = TRUE--------------------------------------------------------------
reward(sol, belief = c(0.9, 0.1)) 


## ----policy, echo = TRUE------------------------------------------------------
policy(sol)


## ----tiger-infinite-horizon, echo = TRUE, fig.width = 8, fig.height = 8, out.width = "100%", fig.cap="The policy graph for the converged infinite-horizon solution of the Tiger problem.", fig.alt="A graph showing the infinite-horizon solution of the Tiger problem."----
plot_policy_graph(sol)


## ----tiger-value-function, echo = TRUE, out.width = "100%", fig.cap="The value function for the solution of the converged Tiger problem.", fig.alt="A line chart with the piecewise linear segments of the value funciton."----
plot_value_function(sol, ylim = c(0,20))


## ----tiger-simulation, echo = TRUE, out.width = "100%", fig.cap="Belief states reached in 50 simulated trajectories of horizon 5.", fig.alt="A dot chart showing the distribution of reached belief states."----
sim <- simulate_POMDP(sol, n = 50, horizon = 5, 
  belief = c(.5, .5), return_beliefs = TRUE)
plot_belief_space(sol, sample = sim$belief_states, ylim = c(0, 12), 
                  jitter = 5)
lines(density(sim$belief_states[, 1], bw = .01, from = 0 , to = 1)) 
axis(2); title(ylab = "Density")


## ----tiger-finite-horizon-pol, echo = TRUE------------------------------------
sol <- solve_POMDP(model = Tiger, horizon = 4, method = "incprune")
sol

policy(sol)


## ----tiger-finite-horizon, echo = TRUE, fig.width = 8, fig.height = 8, out.width = "100%", fig.cap="Policy tree for the Tiger problem solved with a horizon of 4 and a uniform initial belief.", fig.alt="A graph showing the finite-horizon solution of the Tiger problem."----
plot_policy_graph(sol)


## ----tiger-finite-horizon-99, echo = TRUE, fig.width = 8, fig.height = 8, out.width = "100%", fig.cap="Policy tree for the Tiger problem solved with a horizon of 4 and an initial belief of 99 percent that the tiger is to the left.", fig.alt="A graph showing the finite-horizon solution of the Tiger problem."----
sol <- solve_POMDP(model = Tiger, horizon = 4, 
  initial_belief = c(.99, .01), method = "incprune")
reward(sol, belief = c(.99, .01))
plot_policy_graph(sol, belief = c(.99, .01))

