# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit yu-peng.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
library(dplyr)
library(tidyr)
library(table1)
library(plotly)


## ----SLCAREfunctions-interactive, eval = knitr::is_html_output(), layout = "l-body-outset"----
# table1 <- data.frame(
#   `FUNCTION` = c("SLCARE()", "summary()", "print()", "predict()", "plot()",
#                  "reReg()", "multinom()", "kmeans()", "glm.fit()"),
#   `PURPOSE` = c("Conduct LCA with recurrent events data based on semiparametric multiplicative intensity modeling.",
#                 "Generic function; used to summarize estimates for non-functional model parameters along with the associated variance estimates and $p$ values.",
#                 "Generic function; used to initial estimates for the estimation algorithm, convergence criterion, latent class membership probability and predicted number of recurrent events.",
#                 "Generic function; used to predict the posterior number of recurrent events.",
#                 "Generic function; used to generate cumulative baseline intensity function, estimated mean function, model checking plot.",
#                 "Imported from  package reReg; used to find an initial estimate for $\\beta_0$.",
#                 "Imported from  package nnet; used to find an initial estimate for $\\alpha_0$; used to solve the estimating equation to update the estimate for $\\alpha_0$.",
#                 "Imported from package stats; used to find initial estimates for $\\alpha_0$ and $\\beta_0$.",
#                 "Imported from package stats; used to solve the estimating equation to update the estimate for $\\beta_0$.")
# )
# 
# knitr::kable(table1, format = "html", caption = "An overview of the main function and imported functions in SLCARE", booktabs=TRUE) |>
#   kableExtra::kable_styling(position = "center")


## ----SLCAREfunctions-static, eval = knitr::is_latex_output()------------------
table1 <- data.frame(
  `FUNCTION` = c("SLCARE()", " ", "summary()", " ", "print()", " ", " ", "predict()", "plot()", " ",
                 "reReg()", "multinom()", " " , "kmeans()", "glm.fit()", " "),
  `PURPOSE` = c("Conduct LCA with recurrent events data based on semiparametric",
                "multiplicative intensity modeling.",
                "Generic function; used to summarize estimates for model parameters",
                "along with the associated variance estimates and $p$ values.", 
                "Generic function; used to initial estimates for the estimation algorithm",
                "convergence criterion, latent class membership probability and",
                "predicted number of recurrent events.",
                "Generic function; used to predict the posterior number of recurrent events.", 
                "Generic function; used to generate cumulative baseline intensity function",
                "estimated mean function, model checking plot.",
                "Imported from  package reReg; used to find an initial estimate for $\\beta_0$.",
                "Imported from  package nnet; used to find an initial estimate for $\\alpha_0$;",
                "used to solve the estimating equation to update the estimate for $\\alpha_0$.",
                "Imported from package stats; used to find initial estimates for $\\alpha_0$ and $\\beta_0$.",
                "Imported from package stats; used to solve the estimating equation to",
                "update the estimate for $\\beta_0$.")
)

knitr::kable(table1, format = "latex", caption = "An overview of the main function and imported functions in SLCARE", booktabs=TRUE, escape = FALSE) |>
  kableExtra::kable_styling(position = "center")


## -----------------------------------------------------------------------------
library(SLCARE)
subset(SimData, id %in% c("G052") )


## -----------------------------------------------------------------------------
args(SLCARE)


## ----echo = TRUE--------------------------------------------------------------
set.seed(0)
model1 <- SLCARE(formula = "x1 + x2", data = SimData,
                 id_col = "id", start_col = "start", stop_col = "stop", 
                 event_col = "event",  K=2, boot = 20)


## ----echo = TRUE--------------------------------------------------------------
model1


## ----echo = TRUE--------------------------------------------------------------
print(model1, type = "Init")


## ----echo = TRUE--------------------------------------------------------------
print(model1, type = "ConvergeLoss")


## ----echo = TRUE, eval = knitr::is_latex_output()-----------------------------
print(model1, type = "ClassProb")[8:10,]


## ----eval = knitr::is_html_output(), layout = "l-body-outset"-----------------
# knitr::kable(print(model1, type = "ClassProb")[8:10,], format = "html", booktabs=TRUE) |>
#   kableExtra::kable_styling(position = "center")


## ----echo = TRUE, eval = knitr::is_latex_output()-----------------------------
predict(model1)[8:10,]


## ----eval = knitr::is_html_output(), layout = "l-body-outset"-----------------
# knitr::kable(predict(model1)[8:10,], format = "html", booktabs=TRUE) |>
#   kableExtra::kable_styling(position = "center")


## ----echo = TRUE, eval = knitr::is_latex_output()-----------------------------
predict(model1, integer = TRUE)[8:10,]


## ----eval = knitr::is_html_output(), layout = "l-body-outset"-----------------
# knitr::kable(predict(model1, integer = TRUE)[8:10,], format = "html", booktabs=TRUE) |>
#   kableExtra::kable_styling(position = "center")


## ----modelchecking, echo = TRUE, fig.height = 3, fig.cap = "Predicted numbers of events versus the observe numbers of events.", eval = knitr::is_latex_output()----
plot(model1, type = "ModelChecking")


## ----modelchecking-html, fig.height = 5, fig.cap = "Predicted numbers of events versus the observe numbers of events.", eval = knitr::is_html_output(), layout = "l-body-outset"----
# ggplotly(plot(model1, type = "ModelChecking"))


## ----cumbaseline, echo = TRUE, fig.height = 3, fig.cap = "Estimated cumulative baseline intensity function.", eval = knitr::is_latex_output()----
plot(model1, type = "mu0")


## ----cumbaseline-html, fig.height = 5, fig.cap = "Cumulative baseline intensity function.", eval = knitr::is_html_output(), layout = "l-body-outset"----
# cumbaseline <- model1$Estimated_mu0t_gg +
#     geom_line(linewidth = 1) +
#     theme(aspect.ratio = 1) +
#     ggtitle("Plot of Cumulative Baseline Intensity Function") +
#     xlab("t") +
#     ylab("Cumulative Baseline Intensity Function") +
#     expand_limits(x = 0, y = 0)
# ggplotly(cumbaseline)


## ----echo = TRUE--------------------------------------------------------------
model1$est_mu0(c(100, 1000, 5000))


## ----estmeans, echo = TRUE, fig.height = 3, fig.cap = "Estimated mean function for two latent classes.", eval = knitr::is_latex_output()----
plot(model1, type = "EstMeans")


## ----estmeans-html, fig.height = 5, fig.cap = "Estimated mean function for two latent classes.", eval = knitr::is_html_output(), layout = "l-body-outset"----
# ggplotly(plot(model1, type = "EstMeans"))


## ----echo = TRUE--------------------------------------------------------------
data("colorectal", package = "SLCARE")
colorectalSLCARE <- colorectal |>
  dplyr::select(id, time0, time1, new.lesions, treatment, prev.resection) |>
  dplyr::mutate(id = paste0("patient", id), treatment = as.numeric(treatment) -1,
                prev.resection = as.numeric(prev.resection) -1)
str(colorectalSLCARE, vec.len = 3)


## -----------------------------------------------------------------------------
table2 <- data.frame(
  `x` = c("Gamma(1,1)", "Gamma(3,3)", "W = 1"),
  `K=2` = c(0.785, 0.802, 0.462),
  `K=3` = c(0.788, 0.793, 0.459)
)


## ----realentropytable-interactive, eval = knitr::is_html_output(), layout = "l-body-outset"----
# knitr::kable(table2, col.names = c("", "K = 2", "K = 3"), format = "html", caption = "Real data example: Relative entropy calculated with different
# choices of $K$ and $f_{W}(w)$.", booktabs=TRUE) |>
#   kableExtra::kable_styling(position = "center")


## ----realentropytable-static, eval = knitr::is_latex_output()-----------------
knitr::kable(table2, col.names = c("", "K = 2", "K = 3"), format = "latex", caption = "Real data example: Relative entropy calculated with different
choices of $K$ and $f_{W}(w)$.", booktabs=TRUE) |>
  kableExtra::kable_styling(position = "center") 


## ----echo = TRUE--------------------------------------------------------------
set.seed(66)
finalmodel <- SLCARE(formula = "treatment + prev.resection", data = colorectalSLCARE,
       id_col = "id", start_col = "time0", stop_col = "time1", event_col = "new.lesions",
       K = 2, gamma = 3, boot = 200)
summary(finalmodel, digits = 3)


## -----------------------------------------------------------------------------
# Assign latent class membership.
latent_class <- apply(finalmodel$EstimatedTau[,-1],1, function(x) which.max(x))
# Extract covariates, number of observed recurrent events etc. from colorectal_SLCARE.
long_format <- colorectalSLCARE |> filter(new.lesions == 1)
wide_format <- colorectalSLCARE |> filter(new.lesions == 0)
# Calculate number of observed recurrent events
ID_d <- long_format |> group_by(id) |> summarise(observed.events = n())
# Construct a DataFrame with covariates, number of observed recurrent events, latent class membership assigned by SLCARE(). 
wide_format <- wide_format |> left_join(ID_d, by = "id") |> replace_na(list(observed.events = 0))
Z_d <- wide_format |> select(-c("id","time0","time1","new.lesions"))
bind_data_class <- cbind(Z_d, latent_class)
bind_data_class$treatment <- 
  factor(bind_data_class$treatment, 
         levels=c(0,1),
         labels=c("sequential chemotherapy", 
                  "combination chemotherapy"))
bind_data_class$prev.resection <- 
  factor(bind_data_class$prev.resection, 
         levels=c(0,1),
         labels=c("no", # Reference
                  "yes"))
bind_data_class$latent_class <- 
  factor(bind_data_class$latent_class, 
         levels=c(1,2),
         labels=c("Class 1", # Reference
                  "Class 2"))
pvalue <- function(x, ...) {
    # Construct vectors of data y, and groups (strata) g
    y <- unlist(x)
    g <- factor(rep(1:length(x), times=sapply(x, length)))
    if (is.numeric(y)) {
        # For numeric variables, perform a standard 2-sample t-test
        p <- t.test(y ~ g)$p.value
    } else {
        # For categorical variables, perform a chi-squared test of independence
        p <- chisq.test(table(y, g))$p.value
    }
    # Format the p-value, using an HTML entity for the less-than sign.
    # The initial empty string places the output on the line below the variable label.
    # c("", sub("<", "&lt;", format.pval(p, digits=3, eps=0.001)))
    # use "<" for kable
    c("", sub("<", "<", format.pval(p, digits=3, eps=0.001)))
}
table3 <- table1(~ observed.events + treatment + prev.resection | latent_class, data=bind_data_class, overall=F, extra.col=list(`P-value`=pvalue), caption="Real data example: Characteristics of the two latent classes.")


## ----realclasstable-interactive, eval = knitr::is_html_output(), layout = "l-body-outset"----
# knitr::kable(as.data.frame(table3), booktabs=TRUE, format = "html", caption = "Real data example: Characteristics of the two latent classes.") |>
#   kableExtra::kable_styling(position = "center")


## ----realclasstable-static, eval = knitr::is_latex_output()-------------------
table1::t1kable(table3) |>
  kableExtra::kable_styling(position = "center")


## ----realestmean-plotly, fig.height = 5, fig.cap = "Real data example: Estimated mean function of experiencing new colorectal lesions for two classes.", include=knitr::is_html_output(), eval=knitr::is_html_output(), layout = "l-body-outset"----
# ggplotly(plot(finalmodel, type = "EstMeans"))


## ----realestmean-ggplot, fig.height = 3, fig.cap = "Real data example: Estimated mean function of experiencing new colorectal lesions for two classes.", include=knitr::is_latex_output(), eval=knitr::is_latex_output()----
plot(finalmodel, type = "EstMeans")


## ----realmodelcheck-plotly, fig.height = 5, fig.cap = "Real data example: Predicted numbers of new colorectal lesions versus the observed numbers of new colorectal lesions.", include=knitr::is_html_output(), eval=knitr::is_html_output(), layout = "l-body-outset"----
# ggplotly(plot(finalmodel, type = "ModelChecking") +
#   xlim(0, 5) + ylim(0, 5))


## ----realmodelcheck-ggplot, fig.height = 3, fig.cap = "Real data example: Predicted numbers of new colorectal lesions versus the observed numbers of new colorectal lesions.", include=knitr::is_latex_output(), eval=knitr::is_latex_output()----
plot(finalmodel, type = "ModelChecking") +
  xlim(0, 5) + ylim(0, 5)

