# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit pubchemR.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
library(PubChemR)


## ----figure1, out.width = "100%", out.height = "20%", fig.cap = "Interfacing the PubChem's PUG-REST database with the PubChemR package through URL syntax: utilizing queries as function arguments", fig.alt="Interfacing the PubChem's PUG-REST database with the PubChemR."----
 knitr::include_graphics("figures/Figure_1.png")


## ----load, echo = TRUE--------------------------------------------------------
# install.packages("PubChemR", repos = "http://cran.us.r-project.org")
library("PubChemR")


## ----compoundsByName, echo = TRUE---------------------------------------------
compounds <- get_compounds(identifier = c("aspirin", "caffeine", "glucose"), namespace = "name") 
compounds


## ----requestByCID, echo = TRUE------------------------------------------------
request_args(object = compounds)


## ----compound_aspirin, echo = TRUE--------------------------------------------
compound_aspirin <- instance(object = compounds, .which = "aspirin")
compound_aspirin


## ----retrieve_by_props, echo = TRUE-------------------------------------------
retrieve(object = compound_aspirin, .slot = "props", .to.data.frame = TRUE)


## ----compoundsByCID, echo = TRUE----------------------------------------------
compounds <- get_compounds(identifier = c(2244, 305), namespace = "cid") 
compounds


## ----instance_by_cid, echo = TRUE---------------------------------------------
compound_2244 <- instance(object = compounds, .which = 2244)
compound_2244


## ----compoundsBySmiles, echo = TRUE-------------------------------------------
compounds_by_smiles <- get_compounds(identifier = c("CC(=O)OC1=CC=CC=C1C(=O)O", 
                                                    "CN1C=NC2=C1C(=O)N(C(=O)N2C)C"), 
                                     namespace = "smiles")  
compounds_by_smiles


## ----instance_by_instance, echo = TRUE----------------------------------------
compound_smiles <- instance(object = compounds_by_smiles, .which = "CC(=O)OC1=CC=CC=C1C(=O)O")
compound_smiles


## ----substancesBySid, echo = TRUE---------------------------------------------
substances <- get_substances(identifier = c(103164874, 403385742, 403435554), 
                             namespace = "sid") 
substances


## ----instance_substances, echo = TRUE-----------------------------------------
instance(object = substances, .which = 403435554)


## ----retrieve_substances_compound, echo = TRUE--------------------------------
retrieve(object = substances, .which = 403435554, .slot = "compound", .to.data.frame = FALSE)


## ----assayByAid, echo = TRUE--------------------------------------------------
assays <- get_assays(identifier = c(485314, 485341, 504466, 624202, 651820), 
                     namespace = "aid") 
assays


## ----instance_assays_485314, echo=TRUE----------------------------------------
assay_485314 <- instance(object = assays, .which = 485314)
assay_485314


## ----retrieve_assays_results, echo=TRUE---------------------------------------
retrieve(object = assays, .which = 485314, .slot = "results")


## ----properties, echo = TRUE--------------------------------------------------
props <- get_properties(
  properties = c("MolecularWeight", "MolecularFormula", "InChI"),
  identifier = c("aspirin", "caffeine", "glucose"),
  namespace = "name"
)


## ----propertiesPrint, echo = TRUE---------------------------------------------
retrieve(instance(props, "aspirin"), .slot = NULL)


## ----propertiesPrint2, echo = TRUE--------------------------------------------
retrieve(props, .combine.all = TRUE)


## ----propertiesPrint3, echo = TRUE--------------------------------------------
retrieve(props, .combine.all = TRUE,
  .slot = c("MolecularWeight", "MolecularFormula"))


## ----property_map_all, echo = TRUE--------------------------------------------
property_map(type = "all")


## ----get_properties_contain, echo = TRUE--------------------------------------
props <- get_properties(
  properties = c("mass", "molecular"),
  identifier = 2244:2260,
  namespace = "cid",
  propertyMatch = list(
    type = "contain"
  )
)
retrieve(props, .combine.all = TRUE, .to.data.frame = TRUE)


## ----property_map_start, echo = TRUE------------------------------------------
props <- get_properties(
  properties = "molecular",
  identifier = 2244:2260,
  namespace = "cid",
  propertyMatch = list(
    type = "start",
    .ignore.case = TRUE
  )
)
retrieve(props, .combine.all = TRUE, .to.data.frame = TRUE)


## ----property_map_end, echo = TRUE--------------------------------------------
props <- get_properties(
  properties = "mass",
  identifier = 2244:2260,
  namespace = "cid",
  propertyMatch = list(
    type = "end",
    .ignore.case = TRUE
  )
)
retrieve(props, .combine.all = TRUE, .to.data.frame = TRUE)


## ----get_properties_all, echo = TRUE------------------------------------------
props <- get_properties(
  properties = NULL,
  identifier = 2244:2260,
  namespace = "cid",
  propertyMatch = list(
    type = "all"
  )
)
retrieve(props, .combine.all = TRUE)


## ----getSDF, echo = TRUE, eval=FALSE------------------------------------------
#> get_sdf(identifier = 2244, namespace = "cid")


## ----download, echo = TRUE----------------------------------------------------
download( filename = "Aspirin", outformat = "json", path = tempdir(), 
identifier = "aspirin", namespace = "name", domain = "compound", overwrite = TRUE)


## ----chemicalStructure, echo = TRUE-------------------------------------------
chemical_structure <- get_pug_rest(identifier = "10000", 
                                   namespace = "sid", 
                                   domain = "substance", 
                                   output = "JSON")
chemical_structure


## ----chemicalStructureRes, echo = TRUE----------------------------------------
chemical_structure_result <- pubChemData(chemical_structure)


## ----chemical_structure_sid, echo = TRUE--------------------------------------
chemical_structure_result$PC_Substances[[1]]$sid


## ----chemical_structure_sid_res, echo = TRUE----------------------------------
chemical_structure_result$PC_Substances[[1]]$source$db$name


## ----chemical_structure_source_id, echo = TRUE--------------------------------
chemical_structure_result$PC_Substances[[1]]$source$db$source_id


## ----chemical_structure_synonyms, echo = TRUE---------------------------------
chemical_structure_result$PC_Substances[[1]]$synonyms


## ----chemical_structure_comment, echo = TRUE----------------------------------
chemical_structure_result$PC_Substances[[1]]$comment


## ----chemical_structure_xref, echo = TRUE-------------------------------------
chemical_structure_result$PC_Substances[[1]]$xref


## ----chemical_structure_aid, echo = TRUE--------------------------------------
chemical_structure_result$PC_Substances[[1]]$compound[[1]]$atoms$aid


## ----chemical_structure_element, echo = TRUE----------------------------------
chemical_structure_result$PC_Substances[[1]]$compound[[1]]$atoms$element


## ----chemical_structure_aid1, echo = TRUE-------------------------------------
chemical_structure_result$PC_Substances[[1]]$compound[[1]]$bonds$aid1


## ----chemical_structure_aid2, echo = TRUE-------------------------------------
chemical_structure_result$PC_Substances[[1]]$compound[[1]]$bonds$aid2


## ----chemical_structure_order, echo = TRUE------------------------------------
chemical_structure_result$PC_Substances[[1]]$compound[[1]]$bonds$order


## ----chemical_structure_x, echo = TRUE----------------------------------------
chemical_structure_result$PC_Substances[[1]]$compound[[1]]$coords[[1]]$conformers


## ----structureSearch, echo = TRUE---------------------------------------------
structure_search <- get_pug_rest(identifier = "5793", 
                                 namespace = "cid", 
                                 domain = "compound", 
                                 operation = "cids", 
                                 searchtype = "fastidentity", 
                                 options = list(identity_type = "same_connectivity"), 
                                 output = "JSON")
structure_search


## ----structureSearchLength, echo = TRUE---------------------------------------
structure_search_result <- pubChemData(structure_search)
length(structure_search_result$IdentifierList$CID)


## ----structureSearchRes, echo = TRUE------------------------------------------
head(structure_search_result$IdentifierList$CID)


## ----bioassay_data, echo=TRUE-------------------------------------------------
bioassay_data <- get_pug_rest(identifier = "504526", 
                              namespace = "aid", 
                              domain = "assay", 
                              operation = "concise", 
                              output = "CSV")
bioassay_data


## ----bioassay_data_output, echo=TRUE------------------------------------------
bioassay_data_result <- pubChemData(bioassay_data)
head(bioassay_data_result)


## ----geneData, echo = TRUE----------------------------------------------------
geneData <- get_pug_rest(identifier = "13649", 
                         namespace = "geneid", 
                         domain = "gene", 
                         operation = "concise", 
                         output = "CSV")
geneData


## ----geneDataRes, echo = TRUE-------------------------------------------------
geneData_result <- pubChemData(geneData)
head(geneData_result)


## ----proteinData, echo = TRUE-------------------------------------------------
protein_data <- get_pug_rest(identifier = "Q01279", 
                             namespace = "accession", 
                             domain = "protein", 
                             operation = "concise", 
                             output = "CSV")
protein_data


## ----proteinDataRes, echo = TRUE----------------------------------------------
protein_data_result <- pubChemData(protein_data)
head(protein_data_result)


## ----pathwayData, echo = TRUE-------------------------------------------------
pathway_data <- get_pug_rest(identifier = "P00533", 
                             namespace = "accession", 
                             domain = "protein", 
                             operation = "pwaccs", 
                             output = "JSON")
pathway_data


## ----pathwayDataRes, echo = TRUE----------------------------------------------
pathway_data_result <- pubChemData(pathway_data)
head(pathway_data_result$InformationList$Information[[1]]$PathwayAccession)


## ----taxonomyData, echo = TRUE------------------------------------------------
taxonomy_data <- get_pug_rest(identifier = c("2697049"), 
                              namespace = "taxid", 
                              domain = "taxonomy", 
                              operation = "summary", 
                              output = "JSON")
taxonomy_data


## ----taxonomyDataRes, echo = TRUE---------------------------------------------
taxonomy_data_result <- pubChemData(taxonomy_data)
taxonomy_data_result$TaxonomySummaries$TaxonomySummary


## ----cellLineData, echo = TRUE------------------------------------------------
cell_line_data <- get_pug_rest(identifier = c("CHEMBL3308376"), 
                               namespace = "cellacc", 
                               domain = "cell", 
                               operation = "summary", 
                               output = "JSON")
cell_line_data


## ----cellLineDataRes, echo = TRUE---------------------------------------------
cell_line_data_result <- pubChemData(cell_line_data)
cell_line_data_result$CellSummaries$CellSummary


## ----figure2, out.width = "100%", out.height = "20%", fig.cap = "Using the PubChemR package to access PubChem's PUG-View database, with queries in URL syntax serving as function arguments", fig.alt="Using the PubChemR package to access PubChem's PUG-View database."----
 knitr::include_graphics("figures/Figure_2.png")


## ----full_record_aspirin, echo = TRUE-----------------------------------------
full_record_2244 <- get_pug_view(annotation = "data", 
                                 identifier = "2244", 
                                 domain = "compound", 
                                 output = "JSON") 
full_record_2244


## ----full_record_2244_Section, echo = TRUE------------------------------------
sections <- retrieve(object = full_record_2244, .slot = "Section")
sections


## ----full_record_2244_Sections, echo = TRUE-----------------------------------
sectionList(object = sections)


## ----full_record_2244_S1, echo = TRUE-----------------------------------------
s1 <- section(object = sections, .id = "S1")


## ----full_record_2244_s1, echo = TRUE-----------------------------------------
s1


## ----full_record_2244_S11, echo = TRUE----------------------------------------
sectionList(object = s1)


## ----specificHeadings, echo = TRUE--------------------------------------------
specific_headings <- get_pug_view(annotation = "annotations", 
                                  identifier = "Boiling Point", 
                                  domain = "heading", 
                                  output = "JSON", 
                                  headingType = "Compound")

specific_headings


## ----specific_headings_annotation, echo = TRUE--------------------------------
annotation <- retrieve(specific_headings, .slot = "Annotation", .to.data.frame = FALSE)
annotation[[1]]


## ----literature, echo = TRUE--------------------------------------------------
literature <- get_pug_view(annotation = "literature", 
                           identifier = "1234", 
                           domain = "compound", 
                           output = "JSON")
literature


## ----literature_AllURL, echo = TRUE-------------------------------------------
retrieve(literature, .slot = "AllURL")


## ----list3dProteins, echo = TRUE----------------------------------------------
list_3d_proteins <- get_pug_view(annotation = "structure", 
                                 identifier = "2244", 
                                 domain = "compound", 
                                 output = "JSON")
list_3d_proteins


## ----list3dProteinsURL, echo = TRUE-------------------------------------------
retrieve(list_3d_proteins, .slot = "URL")


## ----list3dProteinsNumberOfStructures, echo = TRUE----------------------------
retrieve(list_3d_proteins, .slot = "NumberOfStructures")


## ----list3dProteinsStructures, echo = TRUE------------------------------------
list_3d_proteins_structures <- retrieve(list_3d_proteins, .slot = "Structures", .to.data.frame = FALSE)


## ----list3dProteinsStructuresFirstOne, echo = TRUE----------------------------
list_3d_proteins_structures[[1]]


## ----ncbiLinkouts, echo = TRUE------------------------------------------------
ncbi_linkouts <- get_pug_view(annotation = "linkout", 
                              identifier = "1234", 
                              domain = "compound", 
                              output = "JSON")


## ----ncbi_linkoutsObjUrl, echo = TRUE-----------------------------------------
retrieve(ncbi_linkouts, .slot = "ObjUrl", .to.data.frame = FALSE)

